package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetProfileResponse(
    profile: Option[zio.aws.alexaforbusiness.model.Profile] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse = {
    import GetProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse
      .builder()
      .optionallyWith(profile.map(value => value.buildAwsValue()))(_.profile)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetProfileResponse.ReadOnly =
    zio.aws.alexaforbusiness.model.GetProfileResponse.wrap(buildAwsValue())
}
object GetProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetProfileResponse =
      zio.aws.alexaforbusiness.model
        .GetProfileResponse(profile.map(value => value.asEditable))
    def profile: Option[zio.aws.alexaforbusiness.model.Profile.ReadOnly]
    def getProfile
        : ZIO[Any, AwsError, zio.aws.alexaforbusiness.model.Profile.ReadOnly] =
      AwsError.unwrapOptionField("profile", profile)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse
  ) extends zio.aws.alexaforbusiness.model.GetProfileResponse.ReadOnly {
    override val profile
        : Option[zio.aws.alexaforbusiness.model.Profile.ReadOnly] = scala
      .Option(impl.profile())
      .map(value => zio.aws.alexaforbusiness.model.Profile.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetProfileResponse
  ): zio.aws.alexaforbusiness.model.GetProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
