package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Arn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetProfileRequest(profileArn: Option[Arn] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest = {
    import GetProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest
      .builder()
      .optionallyWith(
        profileArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.profileArn)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.GetProfileRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.GetProfileRequest.wrap(buildAwsValue())
}
object GetProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.GetProfileRequest =
      zio.aws.alexaforbusiness.model
        .GetProfileRequest(profileArn.map(value => value))
    def profileArn: Option[Arn]
    def getProfileArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("profileArn", profileArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest
  ) extends zio.aws.alexaforbusiness.model.GetProfileRequest.ReadOnly {
    override val profileArn: Option[Arn] = scala
      .Option(impl.profileArn())
      .map(value => zio.aws.alexaforbusiness.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.GetProfileRequest
  ): zio.aws.alexaforbusiness.model.GetProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
