package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  DeviceLocale,
  ProfileName,
  MaxVolumeLimit,
  Address,
  Timezone
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateProfileRequest(
    profileName: ProfileName,
    timezone: Timezone,
    address: Address,
    distanceUnit: zio.aws.alexaforbusiness.model.DistanceUnit,
    temperatureUnit: zio.aws.alexaforbusiness.model.TemperatureUnit,
    wakeWord: zio.aws.alexaforbusiness.model.WakeWord,
    locale: Option[DeviceLocale] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    setupModeDisabled: Option[Boolean] = None,
    maxVolumeLimit: Option[MaxVolumeLimit] = None,
    pstnEnabled: Option[Boolean] = None,
    dataRetentionOptIn: Option[Boolean] = None,
    meetingRoomConfiguration: Option[
      zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration
    ] = None,
    tags: Option[Iterable[zio.aws.alexaforbusiness.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest = {
    import CreateProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest
      .builder()
      .profileName(ProfileName.unwrap(profileName): java.lang.String)
      .timezone(Timezone.unwrap(timezone): java.lang.String)
      .address(Address.unwrap(address): java.lang.String)
      .distanceUnit(distanceUnit.unwrap)
      .temperatureUnit(temperatureUnit.unwrap)
      .wakeWord(wakeWord.unwrap)
      .optionallyWith(
        locale.map(value => DeviceLocale.unwrap(value): java.lang.String)
      )(_.locale)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(setupModeDisabled.map(value => value: java.lang.Boolean))(
        _.setupModeDisabled
      )
      .optionallyWith(
        maxVolumeLimit.map(value => MaxVolumeLimit.unwrap(value): Integer)
      )(_.maxVolumeLimit)
      .optionallyWith(pstnEnabled.map(value => value: java.lang.Boolean))(
        _.pstnEnabled
      )
      .optionallyWith(
        dataRetentionOptIn.map(value => value: java.lang.Boolean)
      )(_.dataRetentionOptIn)
      .optionallyWith(
        meetingRoomConfiguration.map(value => value.buildAwsValue())
      )(_.meetingRoomConfiguration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.CreateProfileRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateProfileRequest.wrap(buildAwsValue())
}
object CreateProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateProfileRequest =
      zio.aws.alexaforbusiness.model.CreateProfileRequest(
        profileName,
        timezone,
        address,
        distanceUnit,
        temperatureUnit,
        wakeWord,
        locale.map(value => value),
        clientRequestToken.map(value => value),
        setupModeDisabled.map(value => value),
        maxVolumeLimit.map(value => value),
        pstnEnabled.map(value => value),
        dataRetentionOptIn.map(value => value),
        meetingRoomConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def profileName: ProfileName
    def timezone: Timezone
    def address: Address
    def distanceUnit: zio.aws.alexaforbusiness.model.DistanceUnit
    def temperatureUnit: zio.aws.alexaforbusiness.model.TemperatureUnit
    def wakeWord: zio.aws.alexaforbusiness.model.WakeWord
    def locale: Option[DeviceLocale]
    def clientRequestToken: Option[ClientRequestToken]
    def setupModeDisabled: Option[Boolean]
    def maxVolumeLimit: Option[MaxVolumeLimit]
    def pstnEnabled: Option[Boolean]
    def dataRetentionOptIn: Option[Boolean]
    def meetingRoomConfiguration: Option[
      zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration.ReadOnly
    ]
    def tags: Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getProfileName: ZIO[Any, Nothing, ProfileName] =
      ZIO.succeed(profileName)
    def getTimezone: ZIO[Any, Nothing, Timezone] = ZIO.succeed(timezone)
    def getAddress: ZIO[Any, Nothing, Address] = ZIO.succeed(address)
    def getDistanceUnit
        : ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.DistanceUnit] =
      ZIO.succeed(distanceUnit)
    def getTemperatureUnit
        : ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.TemperatureUnit] =
      ZIO.succeed(temperatureUnit)
    def getWakeWord
        : ZIO[Any, Nothing, zio.aws.alexaforbusiness.model.WakeWord] =
      ZIO.succeed(wakeWord)
    def getLocale: ZIO[Any, AwsError, DeviceLocale] =
      AwsError.unwrapOptionField("locale", locale)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getSetupModeDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("setupModeDisabled", setupModeDisabled)
    def getMaxVolumeLimit: ZIO[Any, AwsError, MaxVolumeLimit] =
      AwsError.unwrapOptionField("maxVolumeLimit", maxVolumeLimit)
    def getPstnEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("pstnEnabled", pstnEnabled)
    def getDataRetentionOptIn: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dataRetentionOptIn", dataRetentionOptIn)
    def getMeetingRoomConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "meetingRoomConfiguration",
      meetingRoomConfiguration
    )
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest
  ) extends zio.aws.alexaforbusiness.model.CreateProfileRequest.ReadOnly {
    override val profileName: ProfileName =
      zio.aws.alexaforbusiness.model.primitives.ProfileName(impl.profileName())
    override val timezone: Timezone =
      zio.aws.alexaforbusiness.model.primitives.Timezone(impl.timezone())
    override val address: Address =
      zio.aws.alexaforbusiness.model.primitives.Address(impl.address())
    override val distanceUnit: zio.aws.alexaforbusiness.model.DistanceUnit =
      zio.aws.alexaforbusiness.model.DistanceUnit.wrap(impl.distanceUnit())
    override val temperatureUnit
        : zio.aws.alexaforbusiness.model.TemperatureUnit =
      zio.aws.alexaforbusiness.model.TemperatureUnit
        .wrap(impl.temperatureUnit())
    override val wakeWord: zio.aws.alexaforbusiness.model.WakeWord =
      zio.aws.alexaforbusiness.model.WakeWord.wrap(impl.wakeWord())
    override val locale: Option[DeviceLocale] = scala
      .Option(impl.locale())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.DeviceLocale(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ClientRequestToken(value)
      )
    override val setupModeDisabled: Option[Boolean] =
      scala.Option(impl.setupModeDisabled()).map(value => value: Boolean)
    override val maxVolumeLimit: Option[MaxVolumeLimit] = scala
      .Option(impl.maxVolumeLimit())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.MaxVolumeLimit(value)
      )
    override val pstnEnabled: Option[Boolean] =
      scala.Option(impl.pstnEnabled()).map(value => value: Boolean)
    override val dataRetentionOptIn: Option[Boolean] =
      scala.Option(impl.dataRetentionOptIn()).map(value => value: Boolean)
    override val meetingRoomConfiguration: Option[
      zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration.ReadOnly
    ] = scala
      .Option(impl.meetingRoomConfiguration())
      .map(value =>
        zio.aws.alexaforbusiness.model.CreateMeetingRoomConfiguration
          .wrap(value)
      )
    override val tags
        : Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateProfileRequest
  ): zio.aws.alexaforbusiness.model.CreateProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
