package zio.aws.alexaforbusiness.model
import java.lang.Integer
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.Minutes
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateInstantBooking(
    durationInMinutes: Minutes,
    enabled: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateInstantBooking = {
    import CreateInstantBooking.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateInstantBooking
      .builder()
      .durationInMinutes(Minutes.unwrap(durationInMinutes): Integer)
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.alexaforbusiness.model.CreateInstantBooking.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateInstantBooking.wrap(buildAwsValue())
}
object CreateInstantBooking {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateInstantBooking
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.alexaforbusiness.model.CreateInstantBooking =
      zio.aws.alexaforbusiness.model
        .CreateInstantBooking(durationInMinutes, enabled)
    def durationInMinutes: Minutes
    def enabled: Boolean
    def getDurationInMinutes: ZIO[Any, Nothing, Minutes] =
      ZIO.succeed(durationInMinutes)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateInstantBooking
  ) extends zio.aws.alexaforbusiness.model.CreateInstantBooking.ReadOnly {
    override val durationInMinutes: Minutes =
      zio.aws.alexaforbusiness.model.primitives
        .Minutes(impl.durationInMinutes())
    override val enabled: Boolean = impl.enabled(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateInstantBooking
  ): zio.aws.alexaforbusiness.model.CreateInstantBooking.ReadOnly = new Wrapper(
    impl
  )
}
