package zio.aws.alexaforbusiness.model
import zio.ZIO
import zio.aws.alexaforbusiness.model.primitives.{
  ClientRequestToken,
  S3KeyPrefix,
  CustomerS3BucketName,
  BusinessReportScheduleName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateBusinessReportScheduleRequest(
    scheduleName: Option[BusinessReportScheduleName] = None,
    s3BucketName: Option[CustomerS3BucketName] = None,
    s3KeyPrefix: Option[S3KeyPrefix] = None,
    format: zio.aws.alexaforbusiness.model.BusinessReportFormat,
    contentRange: zio.aws.alexaforbusiness.model.BusinessReportContentRange,
    recurrence: Option[
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence
    ] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    tags: Option[Iterable[zio.aws.alexaforbusiness.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest = {
    import CreateBusinessReportScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest
      .builder()
      .optionallyWith(
        scheduleName.map(value =>
          BusinessReportScheduleName.unwrap(value): java.lang.String
        )
      )(_.scheduleName)
      .optionallyWith(
        s3BucketName.map(value =>
          CustomerS3BucketName.unwrap(value): java.lang.String
        )
      )(_.s3BucketName)
      .optionallyWith(
        s3KeyPrefix.map(value => S3KeyPrefix.unwrap(value): java.lang.String)
      )(_.s3KeyPrefix)
      .format(format.unwrap)
      .contentRange(contentRange.buildAwsValue())
      .optionallyWith(recurrence.map(value => value.buildAwsValue()))(
        _.recurrence
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleRequest.ReadOnly =
    zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleRequest
      .wrap(buildAwsValue())
}
object CreateBusinessReportScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleRequest =
      zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleRequest(
        scheduleName.map(value => value),
        s3BucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        format,
        contentRange.asEditable,
        recurrence.map(value => value.asEditable),
        clientRequestToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scheduleName: Option[BusinessReportScheduleName]
    def s3BucketName: Option[CustomerS3BucketName]
    def s3KeyPrefix: Option[S3KeyPrefix]
    def format: zio.aws.alexaforbusiness.model.BusinessReportFormat
    def contentRange
        : zio.aws.alexaforbusiness.model.BusinessReportContentRange.ReadOnly
    def recurrence: Option[
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly
    ]
    def clientRequestToken: Option[ClientRequestToken]
    def tags: Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]]
    def getScheduleName: ZIO[Any, AwsError, BusinessReportScheduleName] =
      AwsError.unwrapOptionField("scheduleName", scheduleName)
    def getS3BucketName: ZIO[Any, AwsError, CustomerS3BucketName] =
      AwsError.unwrapOptionField("s3BucketName", s3BucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getFormat: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.BusinessReportFormat
    ] = ZIO.succeed(format)
    def getContentRange: ZIO[
      Any,
      Nothing,
      zio.aws.alexaforbusiness.model.BusinessReportContentRange.ReadOnly
    ] = ZIO.succeed(contentRange)
    def getRecurrence: ZIO[
      Any,
      AwsError,
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly
    ] = AwsError.unwrapOptionField("recurrence", recurrence)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.alexaforbusiness.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest
  ) extends zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleRequest.ReadOnly {
    override val scheduleName: Option[BusinessReportScheduleName] = scala
      .Option(impl.scheduleName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives
          .BusinessReportScheduleName(value)
      )
    override val s3BucketName: Option[CustomerS3BucketName] = scala
      .Option(impl.s3BucketName())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.CustomerS3BucketName(value)
      )
    override val s3KeyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.s3KeyPrefix())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.S3KeyPrefix(value)
      )
    override val format: zio.aws.alexaforbusiness.model.BusinessReportFormat =
      zio.aws.alexaforbusiness.model.BusinessReportFormat.wrap(impl.format())
    override val contentRange
        : zio.aws.alexaforbusiness.model.BusinessReportContentRange.ReadOnly =
      zio.aws.alexaforbusiness.model.BusinessReportContentRange
        .wrap(impl.contentRange())
    override val recurrence: Option[
      zio.aws.alexaforbusiness.model.BusinessReportRecurrence.ReadOnly
    ] = scala
      .Option(impl.recurrence())
      .map(value =>
        zio.aws.alexaforbusiness.model.BusinessReportRecurrence.wrap(value)
      )
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.alexaforbusiness.model.primitives.ClientRequestToken(value)
      )
    override val tags
        : Option[List[zio.aws.alexaforbusiness.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.alexaforbusiness.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.alexaforbusiness.model.CreateBusinessReportScheduleRequest
  ): zio.aws.alexaforbusiness.model.CreateBusinessReportScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
