package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class DeleteCertificateRequest(certificateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.DeleteCertificateRequest = {
    import DeleteCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.DeleteCertificateRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.DeleteCertificateRequest.ReadOnly =
    zio.aws.acm.model.DeleteCertificateRequest.wrap(buildAwsValue())
}
object DeleteCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.DeleteCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.DeleteCertificateRequest =
      zio.aws.acm.model.DeleteCertificateRequest(certificateArn)
    def certificateArn: Arn
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.DeleteCertificateRequest
  ) extends zio.aws.acm.model.DeleteCertificateRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.DeleteCertificateRequest
  ): zio.aws.acm.model.DeleteCertificateRequest.ReadOnly = new Wrapper(impl)
}
