package zio.aws.acm.model
import zio.prelude.data.Optional
import zio.aws.acm.model.primitives.PositiveInteger
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ExpiryEventsConfiguration(
    daysBeforeExpiry: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration = {
    import ExpiryEventsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration
      .builder()
      .optionallyWith(
        daysBeforeExpiry.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.daysBeforeExpiry)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly =
    zio.aws.acm.model.ExpiryEventsConfiguration.wrap(buildAwsValue())
}
object ExpiryEventsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ExpiryEventsConfiguration =
      zio.aws.acm.model
        .ExpiryEventsConfiguration(daysBeforeExpiry.map(value => value))
    def daysBeforeExpiry: Optional[PositiveInteger]
    def getDaysBeforeExpiry: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("daysBeforeExpiry", daysBeforeExpiry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration
  ) extends zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly {
    override val daysBeforeExpiry: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.daysBeforeExpiry())
        .map(value => zio.aws.acm.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration
  ): zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly = new Wrapper(impl)
}
