package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Filters(
    extendedKeyUsage: Optional[
      Iterable[zio.aws.acm.model.ExtendedKeyUsageName]
    ] = Optional.Absent,
    keyUsage: Optional[Iterable[zio.aws.acm.model.KeyUsageName]] =
      Optional.Absent,
    keyTypes: Optional[Iterable[zio.aws.acm.model.KeyAlgorithm]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.acm.model.Filters = {
    import Filters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.Filters
      .builder()
      .optionallyWith(
        extendedKeyUsage.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.extendedKeyUsageWithStrings)
      .optionallyWith(
        keyUsage.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.keyUsageWithStrings)
      .optionallyWith(
        keyTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.keyTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.Filters.ReadOnly =
    zio.aws.acm.model.Filters.wrap(buildAwsValue())
}
object Filters {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acm.model.Filters] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.Filters = zio.aws.acm.model.Filters(
      extendedKeyUsage.map(value => value),
      keyUsage.map(value => value),
      keyTypes.map(value => value)
    )
    def extendedKeyUsage: Optional[List[zio.aws.acm.model.ExtendedKeyUsageName]]
    def keyUsage: Optional[List[zio.aws.acm.model.KeyUsageName]]
    def keyTypes: Optional[List[zio.aws.acm.model.KeyAlgorithm]]
    def getExtendedKeyUsage
        : ZIO[Any, AwsError, List[zio.aws.acm.model.ExtendedKeyUsageName]] =
      AwsError.unwrapOptionField("extendedKeyUsage", extendedKeyUsage)
    def getKeyUsage: ZIO[Any, AwsError, List[zio.aws.acm.model.KeyUsageName]] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getKeyTypes: ZIO[Any, AwsError, List[zio.aws.acm.model.KeyAlgorithm]] =
      AwsError.unwrapOptionField("keyTypes", keyTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.Filters
  ) extends zio.aws.acm.model.Filters.ReadOnly {
    override val extendedKeyUsage
        : Optional[List[zio.aws.acm.model.ExtendedKeyUsageName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedKeyUsage())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.ExtendedKeyUsageName.wrap(item)
          }.toList
        )
    override val keyUsage: Optional[List[zio.aws.acm.model.KeyUsageName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyUsage())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.KeyUsageName.wrap(item)
          }.toList
        )
    override val keyTypes: Optional[List[zio.aws.acm.model.KeyAlgorithm]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.KeyAlgorithm.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.Filters
  ): zio.aws.acm.model.Filters.ReadOnly = new Wrapper(impl)
}
