package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class GetCertificateRequest(certificateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.GetCertificateRequest = {
    import GetCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.GetCertificateRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.GetCertificateRequest.ReadOnly =
    zio.aws.acm.model.GetCertificateRequest.wrap(buildAwsValue())
}
object GetCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.GetCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.GetCertificateRequest =
      zio.aws.acm.model.GetCertificateRequest(certificateArn)
    def certificateArn: Arn
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.GetCertificateRequest
  ) extends zio.aws.acm.model.GetCertificateRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.GetCertificateRequest
  ): zio.aws.acm.model.GetCertificateRequest.ReadOnly = new Wrapper(impl)
}
