package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{
  PrivateKey,
  CertificateChain,
  CertificateBody
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ExportCertificateResponse(
    certificate: Optional[CertificateBody] = Optional.Absent,
    certificateChain: Optional[CertificateChain] = Optional.Absent,
    privateKey: Optional[PrivateKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ExportCertificateResponse = {
    import ExportCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ExportCertificateResponse
      .builder()
      .optionallyWith(
        certificate.map(value =>
          CertificateBody.unwrap(value): java.lang.String
        )
      )(_.certificate)
      .optionallyWith(
        certificateChain.map(value =>
          CertificateChain.unwrap(value): java.lang.String
        )
      )(_.certificateChain)
      .optionallyWith(
        privateKey.map(value => PrivateKey.unwrap(value): java.lang.String)
      )(_.privateKey)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ExportCertificateResponse.ReadOnly =
    zio.aws.acm.model.ExportCertificateResponse.wrap(buildAwsValue())
}
object ExportCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ExportCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ExportCertificateResponse =
      zio.aws.acm.model.ExportCertificateResponse(
        certificate.map(value => value),
        certificateChain.map(value => value),
        privateKey.map(value => value)
      )
    def certificate: Optional[CertificateBody]
    def certificateChain: Optional[CertificateChain]
    def privateKey: Optional[PrivateKey]
    def getCertificate: ZIO[Any, AwsError, CertificateBody] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChain] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getPrivateKey: ZIO[Any, AwsError, PrivateKey] =
      AwsError.unwrapOptionField("privateKey", privateKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ExportCertificateResponse
  ) extends zio.aws.acm.model.ExportCertificateResponse.ReadOnly {
    override val certificate: Optional[CertificateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.certificate())
      .map(value => zio.aws.acm.model.primitives.CertificateBody(value))
    override val certificateChain: Optional[CertificateChain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateChain())
        .map(value => zio.aws.acm.model.primitives.CertificateChain(value))
    override val privateKey: Optional[PrivateKey] = zio.aws.core.internal
      .optionalFromNullable(impl.privateKey())
      .map(value => zio.aws.acm.model.primitives.PrivateKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ExportCertificateResponse
  ): zio.aws.acm.model.ExportCertificateResponse.ReadOnly = new Wrapper(impl)
}
