package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{TStamp, DomainNameString, Arn}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CertificateDetail(
    certificateArn: Option[Arn] = None,
    domainName: Option[DomainNameString] = None,
    subjectAlternativeNames: Option[Iterable[DomainNameString]] = None,
    domainValidationOptions: Option[
      Iterable[zio.aws.acm.model.DomainValidation]
    ] = None,
    serial: Option[String] = None,
    subject: Option[String] = None,
    issuer: Option[String] = None,
    createdAt: Option[TStamp] = None,
    issuedAt: Option[TStamp] = None,
    importedAt: Option[TStamp] = None,
    status: Option[zio.aws.acm.model.CertificateStatus] = None,
    revokedAt: Option[TStamp] = None,
    revocationReason: Option[zio.aws.acm.model.RevocationReason] = None,
    notBefore: Option[TStamp] = None,
    notAfter: Option[TStamp] = None,
    keyAlgorithm: Option[zio.aws.acm.model.KeyAlgorithm] = None,
    signatureAlgorithm: Option[String] = None,
    inUseBy: Option[Iterable[String]] = None,
    failureReason: Option[zio.aws.acm.model.FailureReason] = None,
    `type`: Option[zio.aws.acm.model.CertificateType] = None,
    renewalSummary: Option[zio.aws.acm.model.RenewalSummary] = None,
    keyUsages: Option[Iterable[zio.aws.acm.model.KeyUsage]] = None,
    extendedKeyUsages: Option[Iterable[zio.aws.acm.model.ExtendedKeyUsage]] =
      None,
    certificateAuthorityArn: Option[Arn] = None,
    renewalEligibility: Option[zio.aws.acm.model.RenewalEligibility] = None,
    options: Option[zio.aws.acm.model.CertificateOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.CertificateDetail = {
    import CertificateDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.CertificateDetail
      .builder()
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        domainName.map(value =>
          DomainNameString.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .optionallyWith(
        subjectAlternativeNames.map(value =>
          value.map { item =>
            DomainNameString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNames)
      .optionallyWith(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationOptions)
      .optionallyWith(serial.map(value => value: java.lang.String))(_.serial)
      .optionallyWith(subject.map(value => value: java.lang.String))(_.subject)
      .optionallyWith(issuer.map(value => value: java.lang.String))(_.issuer)
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(issuedAt.map(value => TStamp.unwrap(value): Instant))(
        _.issuedAt
      )
      .optionallyWith(importedAt.map(value => TStamp.unwrap(value): Instant))(
        _.importedAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(revokedAt.map(value => TStamp.unwrap(value): Instant))(
        _.revokedAt
      )
      .optionallyWith(revocationReason.map(value => value.unwrap))(
        _.revocationReason
      )
      .optionallyWith(notBefore.map(value => TStamp.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => TStamp.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(keyAlgorithm.map(value => value.unwrap))(_.keyAlgorithm)
      .optionallyWith(signatureAlgorithm.map(value => value: java.lang.String))(
        _.signatureAlgorithm
      )
      .optionallyWith(
        inUseBy.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.inUseBy)
      .optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(renewalSummary.map(value => value.buildAwsValue()))(
        _.renewalSummary
      )
      .optionallyWith(
        keyUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keyUsages)
      .optionallyWith(
        extendedKeyUsages.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extendedKeyUsages)
      .optionallyWith(
        certificateAuthorityArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.certificateAuthorityArn)
      .optionallyWith(renewalEligibility.map(value => value.unwrap))(
        _.renewalEligibility
      )
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.CertificateDetail.ReadOnly =
    zio.aws.acm.model.CertificateDetail.wrap(buildAwsValue())
}
object CertificateDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.CertificateDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.CertificateDetail =
      zio.aws.acm.model.CertificateDetail(
        certificateArn.map(value => value),
        domainName.map(value => value),
        subjectAlternativeNames.map(value => value),
        domainValidationOptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serial.map(value => value),
        subject.map(value => value),
        issuer.map(value => value),
        createdAt.map(value => value),
        issuedAt.map(value => value),
        importedAt.map(value => value),
        status.map(value => value),
        revokedAt.map(value => value),
        revocationReason.map(value => value),
        notBefore.map(value => value),
        notAfter.map(value => value),
        keyAlgorithm.map(value => value),
        signatureAlgorithm.map(value => value),
        inUseBy.map(value => value),
        failureReason.map(value => value),
        `type`.map(value => value),
        renewalSummary.map(value => value.asEditable),
        keyUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        extendedKeyUsages.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        certificateAuthorityArn.map(value => value),
        renewalEligibility.map(value => value),
        options.map(value => value.asEditable)
      )
    def certificateArn: Option[Arn]
    def domainName: Option[DomainNameString]
    def subjectAlternativeNames: Option[List[DomainNameString]]
    def domainValidationOptions
        : Option[List[zio.aws.acm.model.DomainValidation.ReadOnly]]
    def serial: Option[String]
    def subject: Option[String]
    def issuer: Option[String]
    def createdAt: Option[TStamp]
    def issuedAt: Option[TStamp]
    def importedAt: Option[TStamp]
    def status: Option[zio.aws.acm.model.CertificateStatus]
    def revokedAt: Option[TStamp]
    def revocationReason: Option[zio.aws.acm.model.RevocationReason]
    def notBefore: Option[TStamp]
    def notAfter: Option[TStamp]
    def keyAlgorithm: Option[zio.aws.acm.model.KeyAlgorithm]
    def signatureAlgorithm: Option[String]
    def inUseBy: Option[List[String]]
    def failureReason: Option[zio.aws.acm.model.FailureReason]
    def `type`: Option[zio.aws.acm.model.CertificateType]
    def renewalSummary: Option[zio.aws.acm.model.RenewalSummary.ReadOnly]
    def keyUsages: Option[List[zio.aws.acm.model.KeyUsage.ReadOnly]]
    def extendedKeyUsages
        : Option[List[zio.aws.acm.model.ExtendedKeyUsage.ReadOnly]]
    def certificateAuthorityArn: Option[Arn]
    def renewalEligibility: Option[zio.aws.acm.model.RenewalEligibility]
    def options: Option[zio.aws.acm.model.CertificateOptions.ReadOnly]
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getDomainName: ZIO[Any, AwsError, DomainNameString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getSubjectAlternativeNames: ZIO[Any, AwsError, List[DomainNameString]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNames",
        subjectAlternativeNames
      )
    def getDomainValidationOptions: ZIO[Any, AwsError, List[
      zio.aws.acm.model.DomainValidation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationOptions",
      domainValidationOptions
    )
    def getSerial: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serial", serial)
    def getSubject: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subject", subject)
    def getIssuer: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("issuer", issuer)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getIssuedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("issuedAt", issuedAt)
    def getImportedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("importedAt", importedAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.acm.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRevokedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
    def getRevocationReason
        : ZIO[Any, AwsError, zio.aws.acm.model.RevocationReason] =
      AwsError.unwrapOptionField("revocationReason", revocationReason)
    def getNotBefore: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getKeyAlgorithm: ZIO[Any, AwsError, zio.aws.acm.model.KeyAlgorithm] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithm)
    def getSignatureAlgorithm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("signatureAlgorithm", signatureAlgorithm)
    def getInUseBy: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("inUseBy", inUseBy)
    def getFailureReason: ZIO[Any, AwsError, zio.aws.acm.model.FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
    def getType: ZIO[Any, AwsError, zio.aws.acm.model.CertificateType] =
      AwsError.unwrapOptionField("type", `type`)
    def getRenewalSummary
        : ZIO[Any, AwsError, zio.aws.acm.model.RenewalSummary.ReadOnly] =
      AwsError.unwrapOptionField("renewalSummary", renewalSummary)
    def getKeyUsages
        : ZIO[Any, AwsError, List[zio.aws.acm.model.KeyUsage.ReadOnly]] =
      AwsError.unwrapOptionField("keyUsages", keyUsages)
    def getExtendedKeyUsages: ZIO[Any, AwsError, List[
      zio.aws.acm.model.ExtendedKeyUsage.ReadOnly
    ]] = AwsError.unwrapOptionField("extendedKeyUsages", extendedKeyUsages)
    def getCertificateAuthorityArn: ZIO[Any, AwsError, Arn] = AwsError
      .unwrapOptionField("certificateAuthorityArn", certificateAuthorityArn)
    def getRenewalEligibility
        : ZIO[Any, AwsError, zio.aws.acm.model.RenewalEligibility] =
      AwsError.unwrapOptionField("renewalEligibility", renewalEligibility)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.acm.model.CertificateOptions.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.CertificateDetail
  ) extends zio.aws.acm.model.CertificateDetail.ReadOnly {
    override val certificateArn: Option[Arn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
    override val domainName: Option[DomainNameString] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.acm.model.primitives.DomainNameString(value))
    override val subjectAlternativeNames: Option[List[DomainNameString]] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.primitives.DomainNameString(item)
        }.toList
      )
    override val domainValidationOptions
        : Option[List[zio.aws.acm.model.DomainValidation.ReadOnly]] = scala
      .Option(impl.domainValidationOptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.DomainValidation.wrap(item)
        }.toList
      )
    override val serial: Option[String] =
      scala.Option(impl.serial()).map(value => value: String)
    override val subject: Option[String] =
      scala.Option(impl.subject()).map(value => value: String)
    override val issuer: Option[String] =
      scala.Option(impl.issuer()).map(value => value: String)
    override val createdAt: Option[TStamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val issuedAt: Option[TStamp] = scala
      .Option(impl.issuedAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val importedAt: Option[TStamp] = scala
      .Option(impl.importedAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val status: Option[zio.aws.acm.model.CertificateStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.acm.model.CertificateStatus.wrap(value))
    override val revokedAt: Option[TStamp] = scala
      .Option(impl.revokedAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val revocationReason: Option[zio.aws.acm.model.RevocationReason] =
      scala
        .Option(impl.revocationReason())
        .map(value => zio.aws.acm.model.RevocationReason.wrap(value))
    override val notBefore: Option[TStamp] = scala
      .Option(impl.notBefore())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val notAfter: Option[TStamp] = scala
      .Option(impl.notAfter())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val keyAlgorithm: Option[zio.aws.acm.model.KeyAlgorithm] = scala
      .Option(impl.keyAlgorithm())
      .map(value => zio.aws.acm.model.KeyAlgorithm.wrap(value))
    override val signatureAlgorithm: Option[String] =
      scala.Option(impl.signatureAlgorithm()).map(value => value: String)
    override val inUseBy: Option[List[String]] = scala
      .Option(impl.inUseBy())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val failureReason: Option[zio.aws.acm.model.FailureReason] = scala
      .Option(impl.failureReason())
      .map(value => zio.aws.acm.model.FailureReason.wrap(value))
    override val `type`: Option[zio.aws.acm.model.CertificateType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.acm.model.CertificateType.wrap(value))
    override val renewalSummary
        : Option[zio.aws.acm.model.RenewalSummary.ReadOnly] = scala
      .Option(impl.renewalSummary())
      .map(value => zio.aws.acm.model.RenewalSummary.wrap(value))
    override val keyUsages: Option[List[zio.aws.acm.model.KeyUsage.ReadOnly]] =
      scala
        .Option(impl.keyUsages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.KeyUsage.wrap(item)
          }.toList
        )
    override val extendedKeyUsages
        : Option[List[zio.aws.acm.model.ExtendedKeyUsage.ReadOnly]] = scala
      .Option(impl.extendedKeyUsages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.ExtendedKeyUsage.wrap(item)
        }.toList
      )
    override val certificateAuthorityArn: Option[Arn] = scala
      .Option(impl.certificateAuthorityArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
    override val renewalEligibility
        : Option[zio.aws.acm.model.RenewalEligibility] = scala
      .Option(impl.renewalEligibility())
      .map(value => zio.aws.acm.model.RenewalEligibility.wrap(value))
    override val options
        : Option[zio.aws.acm.model.CertificateOptions.ReadOnly] = scala
      .Option(impl.options())
      .map(value => zio.aws.acm.model.CertificateOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.CertificateDetail
  ): zio.aws.acm.model.CertificateDetail.ReadOnly = new Wrapper(impl)
}
