package zio.aws.acm
import zio.aws.core.config.AwsConfig
import zio.aws.acm.model.RequestCertificateResponse.ReadOnly
import software.amazon.awssdk.services.acm.model.{
  GetAccountConfigurationResponse,
  RemoveTagsFromCertificateResponse,
  GetAccountConfigurationRequest,
  UpdateCertificateOptionsResponse,
  ResendValidationEmailRequest,
  ExportCertificateResponse,
  GetCertificateResponse,
  DeleteCertificateResponse,
  RenewCertificateResponse,
  UpdateCertificateOptionsRequest,
  ImportCertificateResponse,
  RenewCertificateRequest,
  ResendValidationEmailResponse,
  RequestCertificateRequest,
  ListCertificatesResponse,
  ExportCertificateRequest,
  RemoveTagsFromCertificateRequest,
  ListTagsForCertificateRequest,
  ListCertificatesRequest,
  CertificateSummary,
  ListTagsForCertificateResponse,
  ImportCertificateRequest,
  DescribeCertificateResponse,
  AddTagsToCertificateRequest,
  RequestCertificateResponse,
  DescribeCertificateRequest,
  DeleteCertificateRequest,
  PutAccountConfigurationResponse,
  AddTagsToCertificateResponse,
  PutAccountConfigurationRequest,
  GetCertificateRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.acm.{
  AcmAsyncClientBuilder,
  AcmAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Acm extends AspectSupport[Acm] {
  val api: AcmAsyncClient
  def putAccountConfiguration(
      request: zio.aws.acm.model.PutAccountConfigurationRequest
  ): IO[AwsError, Unit]
  def requestCertificate(
      request: zio.aws.acm.model.RequestCertificateRequest
  ): IO[AwsError, ReadOnly]
  def exportCertificate(
      request: zio.aws.acm.model.ExportCertificateRequest
  ): IO[AwsError, zio.aws.acm.model.ExportCertificateResponse.ReadOnly]
  def addTagsToCertificate(
      request: zio.aws.acm.model.AddTagsToCertificateRequest
  ): IO[AwsError, Unit]
  def listTagsForCertificate(
      request: zio.aws.acm.model.ListTagsForCertificateRequest
  ): IO[AwsError, zio.aws.acm.model.ListTagsForCertificateResponse.ReadOnly]
  def deleteCertificate(
      request: zio.aws.acm.model.DeleteCertificateRequest
  ): IO[AwsError, Unit]
  def updateCertificateOptions(
      request: zio.aws.acm.model.UpdateCertificateOptionsRequest
  ): IO[AwsError, Unit]
  def resendValidationEmail(
      request: zio.aws.acm.model.ResendValidationEmailRequest
  ): IO[AwsError, Unit]
  def getCertificate(
      request: zio.aws.acm.model.GetCertificateRequest
  ): IO[AwsError, zio.aws.acm.model.GetCertificateResponse.ReadOnly]
  def describeCertificate(
      request: zio.aws.acm.model.DescribeCertificateRequest
  ): IO[AwsError, zio.aws.acm.model.DescribeCertificateResponse.ReadOnly]
  def removeTagsFromCertificate(
      request: zio.aws.acm.model.RemoveTagsFromCertificateRequest
  ): IO[AwsError, Unit]
  def renewCertificate(
      request: zio.aws.acm.model.RenewCertificateRequest
  ): IO[AwsError, Unit]
  def listCertificates(
      request: zio.aws.acm.model.ListCertificatesRequest
  ): ZStream[Any, AwsError, zio.aws.acm.model.CertificateSummary.ReadOnly]
  def listCertificatesPaginated(
      request: zio.aws.acm.model.ListCertificatesRequest
  ): IO[AwsError, zio.aws.acm.model.ListCertificatesResponse.ReadOnly]
  def importCertificate(
      request: zio.aws.acm.model.ImportCertificateRequest
  ): IO[AwsError, zio.aws.acm.model.ImportCertificateResponse.ReadOnly]
  def getAccountConfiguration()
      : IO[AwsError, zio.aws.acm.model.GetAccountConfigurationResponse.ReadOnly]
}
object Acm {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Acm] = customized(identity)
  def customized(
      customization: AcmAsyncClientBuilder => AcmAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Acm] = managed(
    customization
  ).toLayer
  def managed(
      customization: AcmAsyncClientBuilder => AcmAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Acm] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AcmAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AcmAsyncClient, AcmAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[AcmAsyncClient, AcmAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new AcmImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AcmImpl[R](
      override val api: AcmAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Acm
      with AwsServiceBase[R] {
    override val serviceName: String = "Acm"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AcmImpl[R1] = new AcmImpl(api, newAspect, r)
    def putAccountConfiguration(
        request: zio.aws.acm.model.PutAccountConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      PutAccountConfigurationRequest,
      PutAccountConfigurationResponse
    ]("putAccountConfiguration", api.putAccountConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def requestCertificate(
        request: zio.aws.acm.model.RequestCertificateRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      RequestCertificateRequest,
      RequestCertificateResponse
    ]("requestCertificate", api.requestCertificate)(request.buildAwsValue())
      .map(zio.aws.acm.model.RequestCertificateResponse.wrap)
      .provideEnvironment(r)
    def exportCertificate(
        request: zio.aws.acm.model.ExportCertificateRequest
    ): IO[AwsError, zio.aws.acm.model.ExportCertificateResponse.ReadOnly] =
      asyncRequestResponse[ExportCertificateRequest, ExportCertificateResponse](
        "exportCertificate",
        api.exportCertificate
      )(request.buildAwsValue())
        .map(zio.aws.acm.model.ExportCertificateResponse.wrap)
        .provideEnvironment(r)
    def addTagsToCertificate(
        request: zio.aws.acm.model.AddTagsToCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AddTagsToCertificateRequest,
      AddTagsToCertificateResponse
    ]("addTagsToCertificate", api.addTagsToCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listTagsForCertificate(
        request: zio.aws.acm.model.ListTagsForCertificateRequest
    ): IO[AwsError, zio.aws.acm.model.ListTagsForCertificateResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForCertificateRequest,
        ListTagsForCertificateResponse
      ]("listTagsForCertificate", api.listTagsForCertificate)(
        request.buildAwsValue()
      ).map(zio.aws.acm.model.ListTagsForCertificateResponse.wrap)
        .provideEnvironment(r)
    def deleteCertificate(
        request: zio.aws.acm.model.DeleteCertificateRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteCertificateRequest, DeleteCertificateResponse](
        "deleteCertificate",
        api.deleteCertificate
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def updateCertificateOptions(
        request: zio.aws.acm.model.UpdateCertificateOptionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UpdateCertificateOptionsRequest,
      UpdateCertificateOptionsResponse
    ]("updateCertificateOptions", api.updateCertificateOptions)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def resendValidationEmail(
        request: zio.aws.acm.model.ResendValidationEmailRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ResendValidationEmailRequest,
      ResendValidationEmailResponse
    ]("resendValidationEmail", api.resendValidationEmail)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getCertificate(
        request: zio.aws.acm.model.GetCertificateRequest
    ): IO[AwsError, zio.aws.acm.model.GetCertificateResponse.ReadOnly] =
      asyncRequestResponse[GetCertificateRequest, GetCertificateResponse](
        "getCertificate",
        api.getCertificate
      )(request.buildAwsValue())
        .map(zio.aws.acm.model.GetCertificateResponse.wrap)
        .provideEnvironment(r)
    def describeCertificate(
        request: zio.aws.acm.model.DescribeCertificateRequest
    ): IO[AwsError, zio.aws.acm.model.DescribeCertificateResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeCertificateRequest,
        DescribeCertificateResponse
      ]("describeCertificate", api.describeCertificate)(request.buildAwsValue())
        .map(zio.aws.acm.model.DescribeCertificateResponse.wrap)
        .provideEnvironment(r)
    def removeTagsFromCertificate(
        request: zio.aws.acm.model.RemoveTagsFromCertificateRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      RemoveTagsFromCertificateRequest,
      RemoveTagsFromCertificateResponse
    ]("removeTagsFromCertificate", api.removeTagsFromCertificate)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def renewCertificate(
        request: zio.aws.acm.model.RenewCertificateRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[RenewCertificateRequest, RenewCertificateResponse](
        "renewCertificate",
        api.renewCertificate
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def listCertificates(
        request: zio.aws.acm.model.ListCertificatesRequest
    ): ZStream[Any, AwsError, zio.aws.acm.model.CertificateSummary.ReadOnly] =
      asyncSimplePaginatedRequest[
        ListCertificatesRequest,
        ListCertificatesResponse,
        CertificateSummary
      ](
        "listCertificates",
        api.listCertificates,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.certificateSummaryList().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.acm.model.CertificateSummary.wrap(item))
        .provideEnvironment(r)
    def listCertificatesPaginated(
        request: zio.aws.acm.model.ListCertificatesRequest
    ): IO[AwsError, zio.aws.acm.model.ListCertificatesResponse.ReadOnly] =
      asyncRequestResponse[ListCertificatesRequest, ListCertificatesResponse](
        "listCertificates",
        api.listCertificates
      )(request.buildAwsValue())
        .map(zio.aws.acm.model.ListCertificatesResponse.wrap)
        .provideEnvironment(r)
    def importCertificate(
        request: zio.aws.acm.model.ImportCertificateRequest
    ): IO[AwsError, zio.aws.acm.model.ImportCertificateResponse.ReadOnly] =
      asyncRequestResponse[ImportCertificateRequest, ImportCertificateResponse](
        "importCertificate",
        api.importCertificate
      )(request.buildAwsValue())
        .map(zio.aws.acm.model.ImportCertificateResponse.wrap)
        .provideEnvironment(r)
    def getAccountConfiguration(): IO[
      AwsError,
      zio.aws.acm.model.GetAccountConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAccountConfigurationRequest,
      GetAccountConfigurationResponse
    ]("getAccountConfiguration", api.getAccountConfiguration)(
      GetAccountConfigurationRequest.builder().build()
    ).map(zio.aws.acm.model.GetAccountConfigurationResponse.wrap)
      .provideEnvironment(r)
  }
  def putAccountConfiguration(
      request: zio.aws.acm.model.PutAccountConfigurationRequest
  ): ZIO[zio.aws.acm.Acm, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putAccountConfiguration(request))
  def requestCertificate(
      request: zio.aws.acm.model.RequestCertificateRequest
  ): ZIO[zio.aws.acm.Acm, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.requestCertificate(request))
  def exportCertificate(
      request: zio.aws.acm.model.ExportCertificateRequest
  ): ZIO[
    zio.aws.acm.Acm,
    AwsError,
    zio.aws.acm.model.ExportCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportCertificate(request))
  def addTagsToCertificate(
      request: zio.aws.acm.model.AddTagsToCertificateRequest
  ): ZIO[zio.aws.acm.Acm, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addTagsToCertificate(request))
  def listTagsForCertificate(
      request: zio.aws.acm.model.ListTagsForCertificateRequest
  ): ZIO[
    zio.aws.acm.Acm,
    AwsError,
    zio.aws.acm.model.ListTagsForCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForCertificate(request))
  def deleteCertificate(
      request: zio.aws.acm.model.DeleteCertificateRequest
  ): ZIO[zio.aws.acm.Acm, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCertificate(request))
  def updateCertificateOptions(
      request: zio.aws.acm.model.UpdateCertificateOptionsRequest
  ): ZIO[zio.aws.acm.Acm, AwsError, Unit] =
    ZIO.serviceWithZIO(_.updateCertificateOptions(request))
  def resendValidationEmail(
      request: zio.aws.acm.model.ResendValidationEmailRequest
  ): ZIO[zio.aws.acm.Acm, AwsError, Unit] =
    ZIO.serviceWithZIO(_.resendValidationEmail(request))
  def getCertificate(request: zio.aws.acm.model.GetCertificateRequest): ZIO[
    zio.aws.acm.Acm,
    AwsError,
    zio.aws.acm.model.GetCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCertificate(request))
  def describeCertificate(
      request: zio.aws.acm.model.DescribeCertificateRequest
  ): ZIO[
    zio.aws.acm.Acm,
    AwsError,
    zio.aws.acm.model.DescribeCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCertificate(request))
  def removeTagsFromCertificate(
      request: zio.aws.acm.model.RemoveTagsFromCertificateRequest
  ): ZIO[zio.aws.acm.Acm, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeTagsFromCertificate(request))
  def renewCertificate(
      request: zio.aws.acm.model.RenewCertificateRequest
  ): ZIO[zio.aws.acm.Acm, AwsError, Unit] =
    ZIO.serviceWithZIO(_.renewCertificate(request))
  def listCertificates(
      request: zio.aws.acm.model.ListCertificatesRequest
  ): ZStream[
    zio.aws.acm.Acm,
    AwsError,
    zio.aws.acm.model.CertificateSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listCertificates(request))
  def listCertificatesPaginated(
      request: zio.aws.acm.model.ListCertificatesRequest
  ): ZIO[
    zio.aws.acm.Acm,
    AwsError,
    zio.aws.acm.model.ListCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listCertificatesPaginated(request))
  def importCertificate(
      request: zio.aws.acm.model.ImportCertificateRequest
  ): ZIO[
    zio.aws.acm.Acm,
    AwsError,
    zio.aws.acm.model.ImportCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importCertificate(request))
  def getAccountConfiguration(): ZIO[
    zio.aws.acm.Acm,
    AwsError,
    zio.aws.acm.model.GetAccountConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountConfiguration())
}
