package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{
  CertificateChainBlob,
  PrivateKeyBlob,
  CertificateBodyBlob,
  Arn
}
import scala.jdk.CollectionConverters.*
final case class ImportCertificateRequest(
    certificateArn: Option[Arn] = None,
    certificate: CertificateBodyBlob,
    privateKey: PrivateKeyBlob,
    certificateChain: Option[CertificateChainBlob] = None,
    tags: Option[Iterable[zio.aws.acm.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ImportCertificateRequest = {
    import ImportCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ImportCertificateRequest
      .builder()
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .certificate(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(certificate.toArray[Byte])
      )
      .privateKey(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(privateKey.toArray[Byte])
      )
      .optionallyWith(
        certificateChain.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.certificateChain)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ImportCertificateRequest.ReadOnly =
    zio.aws.acm.model.ImportCertificateRequest.wrap(buildAwsValue())
}
object ImportCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ImportCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ImportCertificateRequest =
      zio.aws.acm.model.ImportCertificateRequest(
        certificateArn.map(value => value),
        certificate,
        privateKey,
        certificateChain.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def certificateArn: Option[Arn]
    def certificate: CertificateBodyBlob
    def privateKey: PrivateKeyBlob
    def certificateChain: Option[CertificateChainBlob]
    def tags: Option[List[zio.aws.acm.model.Tag.ReadOnly]]
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificate: ZIO[Any, Nothing, CertificateBodyBlob] =
      ZIO.succeed(certificate)
    def getPrivateKey: ZIO[Any, Nothing, PrivateKeyBlob] =
      ZIO.succeed(privateKey)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChainBlob] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getTags: ZIO[Any, AwsError, List[zio.aws.acm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ImportCertificateRequest
  ) extends zio.aws.acm.model.ImportCertificateRequest.ReadOnly {
    override val certificateArn: Option[Arn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
    override val certificate: CertificateBodyBlob =
      zio.aws.acm.model.primitives.CertificateBodyBlob(
        zio.Chunk.fromArray(impl.certificate().asByteArrayUnsafe())
      )
    override val privateKey: PrivateKeyBlob =
      zio.aws.acm.model.primitives.PrivateKeyBlob(
        zio.Chunk.fromArray(impl.privateKey().asByteArrayUnsafe())
      )
    override val certificateChain: Option[CertificateChainBlob] = scala
      .Option(impl.certificateChain())
      .map(value =>
        zio.aws.acm.model.primitives
          .CertificateChainBlob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val tags: Option[List[zio.aws.acm.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ImportCertificateRequest
  ): zio.aws.acm.model.ImportCertificateRequest.ReadOnly = new Wrapper(impl)
}
