package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.DomainNameString
import scala.jdk.CollectionConverters.*
final case class DomainValidationOption(
    domainName: DomainNameString,
    validationDomain: DomainNameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.DomainValidationOption = {
    import DomainValidationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.DomainValidationOption
      .builder()
      .domainName(DomainNameString.unwrap(domainName): java.lang.String)
      .validationDomain(
        DomainNameString.unwrap(validationDomain): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.acm.model.DomainValidationOption.ReadOnly =
    zio.aws.acm.model.DomainValidationOption.wrap(buildAwsValue())
}
object DomainValidationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.DomainValidationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.DomainValidationOption =
      zio.aws.acm.model.DomainValidationOption(domainName, validationDomain)
    def domainName: DomainNameString
    def validationDomain: DomainNameString
    def getDomainName: ZIO[Any, Nothing, DomainNameString] =
      ZIO.succeed(domainName)
    def getValidationDomain: ZIO[Any, Nothing, DomainNameString] =
      ZIO.succeed(validationDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.DomainValidationOption
  ) extends zio.aws.acm.model.DomainValidationOption.ReadOnly {
    override val domainName: DomainNameString =
      zio.aws.acm.model.primitives.DomainNameString(impl.domainName())
    override val validationDomain: DomainNameString =
      zio.aws.acm.model.primitives.DomainNameString(impl.validationDomain())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.DomainValidationOption
  ): zio.aws.acm.model.DomainValidationOption.ReadOnly = new Wrapper(impl)
}
