package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.DomainNameString
import scala.jdk.CollectionConverters.*
final case class DomainValidation(
    domainName: DomainNameString,
    validationEmails: Option[Iterable[String]] = None,
    validationDomain: Option[DomainNameString] = None,
    validationStatus: Option[zio.aws.acm.model.DomainStatus] = None,
    resourceRecord: Option[zio.aws.acm.model.ResourceRecord] = None,
    validationMethod: Option[zio.aws.acm.model.ValidationMethod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.DomainValidation = {
    import DomainValidation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.DomainValidation
      .builder()
      .domainName(DomainNameString.unwrap(domainName): java.lang.String)
      .optionallyWith(
        validationEmails.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.validationEmails)
      .optionallyWith(
        validationDomain.map(value =>
          DomainNameString.unwrap(value): java.lang.String
        )
      )(_.validationDomain)
      .optionallyWith(validationStatus.map(value => value.unwrap))(
        _.validationStatus
      )
      .optionallyWith(resourceRecord.map(value => value.buildAwsValue()))(
        _.resourceRecord
      )
      .optionallyWith(validationMethod.map(value => value.unwrap))(
        _.validationMethod
      )
      .build()
  }
  def asReadOnly: zio.aws.acm.model.DomainValidation.ReadOnly =
    zio.aws.acm.model.DomainValidation.wrap(buildAwsValue())
}
object DomainValidation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.DomainValidation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.DomainValidation =
      zio.aws.acm.model.DomainValidation(
        domainName,
        validationEmails.map(value => value),
        validationDomain.map(value => value),
        validationStatus.map(value => value),
        resourceRecord.map(value => value.asEditable),
        validationMethod.map(value => value)
      )
    def domainName: DomainNameString
    def validationEmails: Option[List[String]]
    def validationDomain: Option[DomainNameString]
    def validationStatus: Option[zio.aws.acm.model.DomainStatus]
    def resourceRecord: Option[zio.aws.acm.model.ResourceRecord.ReadOnly]
    def validationMethod: Option[zio.aws.acm.model.ValidationMethod]
    def getDomainName: ZIO[Any, Nothing, DomainNameString] =
      ZIO.succeed(domainName)
    def getValidationEmails: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("validationEmails", validationEmails)
    def getValidationDomain: ZIO[Any, AwsError, DomainNameString] =
      AwsError.unwrapOptionField("validationDomain", validationDomain)
    def getValidationStatus
        : ZIO[Any, AwsError, zio.aws.acm.model.DomainStatus] =
      AwsError.unwrapOptionField("validationStatus", validationStatus)
    def getResourceRecord
        : ZIO[Any, AwsError, zio.aws.acm.model.ResourceRecord.ReadOnly] =
      AwsError.unwrapOptionField("resourceRecord", resourceRecord)
    def getValidationMethod
        : ZIO[Any, AwsError, zio.aws.acm.model.ValidationMethod] =
      AwsError.unwrapOptionField("validationMethod", validationMethod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.DomainValidation
  ) extends zio.aws.acm.model.DomainValidation.ReadOnly {
    override val domainName: DomainNameString =
      zio.aws.acm.model.primitives.DomainNameString(impl.domainName())
    override val validationEmails: Option[List[String]] = scala
      .Option(impl.validationEmails())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val validationDomain: Option[DomainNameString] = scala
      .Option(impl.validationDomain())
      .map(value => zio.aws.acm.model.primitives.DomainNameString(value))
    override val validationStatus: Option[zio.aws.acm.model.DomainStatus] =
      scala
        .Option(impl.validationStatus())
        .map(value => zio.aws.acm.model.DomainStatus.wrap(value))
    override val resourceRecord
        : Option[zio.aws.acm.model.ResourceRecord.ReadOnly] = scala
      .Option(impl.resourceRecord())
      .map(value => zio.aws.acm.model.ResourceRecord.wrap(value))
    override val validationMethod: Option[zio.aws.acm.model.ValidationMethod] =
      scala
        .Option(impl.validationMethod())
        .map(value => zio.aws.acm.model.ValidationMethod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.DomainValidation
  ): zio.aws.acm.model.DomainValidation.ReadOnly = new Wrapper(impl)
}
