package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{
  PrivateKey,
  CertificateChain,
  CertificateBody
}
import scala.jdk.CollectionConverters.*
final case class ExportCertificateResponse(
    certificate: Option[CertificateBody] = None,
    certificateChain: Option[CertificateChain] = None,
    privateKey: Option[PrivateKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ExportCertificateResponse = {
    import ExportCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ExportCertificateResponse
      .builder()
      .optionallyWith(
        certificate.map(value =>
          CertificateBody.unwrap(value): java.lang.String
        )
      )(_.certificate)
      .optionallyWith(
        certificateChain.map(value =>
          CertificateChain.unwrap(value): java.lang.String
        )
      )(_.certificateChain)
      .optionallyWith(
        privateKey.map(value => PrivateKey.unwrap(value): java.lang.String)
      )(_.privateKey)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ExportCertificateResponse.ReadOnly =
    zio.aws.acm.model.ExportCertificateResponse.wrap(buildAwsValue())
}
object ExportCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ExportCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ExportCertificateResponse =
      zio.aws.acm.model.ExportCertificateResponse(
        certificate.map(value => value),
        certificateChain.map(value => value),
        privateKey.map(value => value)
      )
    def certificate: Option[CertificateBody]
    def certificateChain: Option[CertificateChain]
    def privateKey: Option[PrivateKey]
    def getCertificate: ZIO[Any, AwsError, CertificateBody] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChain] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
    def getPrivateKey: ZIO[Any, AwsError, PrivateKey] =
      AwsError.unwrapOptionField("privateKey", privateKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ExportCertificateResponse
  ) extends zio.aws.acm.model.ExportCertificateResponse.ReadOnly {
    override val certificate: Option[CertificateBody] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.acm.model.primitives.CertificateBody(value))
    override val certificateChain: Option[CertificateChain] = scala
      .Option(impl.certificateChain())
      .map(value => zio.aws.acm.model.primitives.CertificateChain(value))
    override val privateKey: Option[PrivateKey] = scala
      .Option(impl.privateKey())
      .map(value => zio.aws.acm.model.primitives.PrivateKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ExportCertificateResponse
  ): zio.aws.acm.model.ExportCertificateResponse.ReadOnly = new Wrapper(impl)
}
