package zio.aws.acm.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.PositiveInteger
import scala.jdk.CollectionConverters.*
final case class ExpiryEventsConfiguration(
    daysBeforeExpiry: Option[PositiveInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration = {
    import ExpiryEventsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration
      .builder()
      .optionallyWith(
        daysBeforeExpiry.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.daysBeforeExpiry)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly =
    zio.aws.acm.model.ExpiryEventsConfiguration.wrap(buildAwsValue())
}
object ExpiryEventsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ExpiryEventsConfiguration =
      zio.aws.acm.model
        .ExpiryEventsConfiguration(daysBeforeExpiry.map(value => value))
    def daysBeforeExpiry: Option[PositiveInteger]
    def getDaysBeforeExpiry: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("daysBeforeExpiry", daysBeforeExpiry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration
  ) extends zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly {
    override val daysBeforeExpiry: Option[PositiveInteger] = scala
      .Option(impl.daysBeforeExpiry())
      .map(value => zio.aws.acm.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ExpiryEventsConfiguration
  ): zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly = new Wrapper(impl)
}
