package zio.aws.acm.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{MaxItems, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListCertificatesRequest(
    certificateStatuses: Option[Iterable[zio.aws.acm.model.CertificateStatus]] =
      None,
    includes: Option[zio.aws.acm.model.Filters] = None,
    nextToken: Option[NextToken] = None,
    maxItems: Option[MaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ListCertificatesRequest = {
    import ListCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ListCertificatesRequest
      .builder()
      .optionallyWith(
        certificateStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.certificateStatusesWithStrings)
      .optionallyWith(includes.map(value => value.buildAwsValue()))(_.includes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ListCertificatesRequest.ReadOnly =
    zio.aws.acm.model.ListCertificatesRequest.wrap(buildAwsValue())
}
object ListCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ListCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ListCertificatesRequest =
      zio.aws.acm.model.ListCertificatesRequest(
        certificateStatuses.map(value => value),
        includes.map(value => value.asEditable),
        nextToken.map(value => value),
        maxItems.map(value => value)
      )
    def certificateStatuses: Option[List[zio.aws.acm.model.CertificateStatus]]
    def includes: Option[zio.aws.acm.model.Filters.ReadOnly]
    def nextToken: Option[NextToken]
    def maxItems: Option[MaxItems]
    def getCertificateStatuses
        : ZIO[Any, AwsError, List[zio.aws.acm.model.CertificateStatus]] =
      AwsError.unwrapOptionField("certificateStatuses", certificateStatuses)
    def getIncludes: ZIO[Any, AwsError, zio.aws.acm.model.Filters.ReadOnly] =
      AwsError.unwrapOptionField("includes", includes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ListCertificatesRequest
  ) extends zio.aws.acm.model.ListCertificatesRequest.ReadOnly {
    override val certificateStatuses
        : Option[List[zio.aws.acm.model.CertificateStatus]] = scala
      .Option(impl.certificateStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.CertificateStatus.wrap(item)
        }.toList
      )
    override val includes: Option[zio.aws.acm.model.Filters.ReadOnly] = scala
      .Option(impl.includes())
      .map(value => zio.aws.acm.model.Filters.wrap(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.acm.model.primitives.NextToken(value))
    override val maxItems: Option[MaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.acm.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ListCertificatesRequest
  ): zio.aws.acm.model.ListCertificatesRequest.ReadOnly = new Wrapper(impl)
}
