package zio.aws.acm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.acm.model.primitives.{
  TStamp,
  NullableBoolean,
  DomainNameString,
  Arn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class CertificateSummary(
    certificateArn: Optional[Arn] = Optional.Absent,
    domainName: Optional[DomainNameString] = Optional.Absent,
    subjectAlternativeNameSummaries: Optional[Iterable[DomainNameString]] =
      Optional.Absent,
    hasAdditionalSubjectAlternativeNames: Optional[NullableBoolean] =
      Optional.Absent,
    status: Optional[zio.aws.acm.model.CertificateStatus] = Optional.Absent,
    `type`: Optional[zio.aws.acm.model.CertificateType] = Optional.Absent,
    keyAlgorithm: Optional[zio.aws.acm.model.KeyAlgorithm] = Optional.Absent,
    keyUsages: Optional[Iterable[zio.aws.acm.model.KeyUsageName]] =
      Optional.Absent,
    extendedKeyUsages: Optional[
      Iterable[zio.aws.acm.model.ExtendedKeyUsageName]
    ] = Optional.Absent,
    inUse: Optional[NullableBoolean] = Optional.Absent,
    exported: Optional[NullableBoolean] = Optional.Absent,
    renewalEligibility: Optional[zio.aws.acm.model.RenewalEligibility] =
      Optional.Absent,
    notBefore: Optional[TStamp] = Optional.Absent,
    notAfter: Optional[TStamp] = Optional.Absent,
    createdAt: Optional[TStamp] = Optional.Absent,
    issuedAt: Optional[TStamp] = Optional.Absent,
    importedAt: Optional[TStamp] = Optional.Absent,
    revokedAt: Optional[TStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.CertificateSummary = {
    import CertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.CertificateSummary
      .builder()
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        domainName.map(value =>
          DomainNameString.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .optionallyWith(
        subjectAlternativeNameSummaries.map(value =>
          value.map { item =>
            DomainNameString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subjectAlternativeNameSummaries)
      .optionallyWith(
        hasAdditionalSubjectAlternativeNames.map(value =>
          value: java.lang.Boolean
        )
      )(_.hasAdditionalSubjectAlternativeNames)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(keyAlgorithm.map(value => value.unwrap))(_.keyAlgorithm)
      .optionallyWith(
        keyUsages.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.keyUsagesWithStrings)
      .optionallyWith(
        extendedKeyUsages.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.extendedKeyUsagesWithStrings)
      .optionallyWith(inUse.map(value => value: java.lang.Boolean))(_.inUse)
      .optionallyWith(exported.map(value => value: java.lang.Boolean))(
        _.exported
      )
      .optionallyWith(renewalEligibility.map(value => value.unwrap))(
        _.renewalEligibility
      )
      .optionallyWith(notBefore.map(value => TStamp.unwrap(value): Instant))(
        _.notBefore
      )
      .optionallyWith(notAfter.map(value => TStamp.unwrap(value): Instant))(
        _.notAfter
      )
      .optionallyWith(createdAt.map(value => TStamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(issuedAt.map(value => TStamp.unwrap(value): Instant))(
        _.issuedAt
      )
      .optionallyWith(importedAt.map(value => TStamp.unwrap(value): Instant))(
        _.importedAt
      )
      .optionallyWith(revokedAt.map(value => TStamp.unwrap(value): Instant))(
        _.revokedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.acm.model.CertificateSummary.ReadOnly =
    zio.aws.acm.model.CertificateSummary.wrap(buildAwsValue())
}
object CertificateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.CertificateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.CertificateSummary =
      zio.aws.acm.model.CertificateSummary(
        certificateArn.map(value => value),
        domainName.map(value => value),
        subjectAlternativeNameSummaries.map(value => value),
        hasAdditionalSubjectAlternativeNames.map(value => value),
        status.map(value => value),
        `type`.map(value => value),
        keyAlgorithm.map(value => value),
        keyUsages.map(value => value),
        extendedKeyUsages.map(value => value),
        inUse.map(value => value),
        exported.map(value => value),
        renewalEligibility.map(value => value),
        notBefore.map(value => value),
        notAfter.map(value => value),
        createdAt.map(value => value),
        issuedAt.map(value => value),
        importedAt.map(value => value),
        revokedAt.map(value => value)
      )
    def certificateArn: Optional[Arn]
    def domainName: Optional[DomainNameString]
    def subjectAlternativeNameSummaries: Optional[List[DomainNameString]]
    def hasAdditionalSubjectAlternativeNames: Optional[NullableBoolean]
    def status: Optional[zio.aws.acm.model.CertificateStatus]
    def `type`: Optional[zio.aws.acm.model.CertificateType]
    def keyAlgorithm: Optional[zio.aws.acm.model.KeyAlgorithm]
    def keyUsages: Optional[List[zio.aws.acm.model.KeyUsageName]]
    def extendedKeyUsages
        : Optional[List[zio.aws.acm.model.ExtendedKeyUsageName]]
    def inUse: Optional[NullableBoolean]
    def exported: Optional[NullableBoolean]
    def renewalEligibility: Optional[zio.aws.acm.model.RenewalEligibility]
    def notBefore: Optional[TStamp]
    def notAfter: Optional[TStamp]
    def createdAt: Optional[TStamp]
    def issuedAt: Optional[TStamp]
    def importedAt: Optional[TStamp]
    def revokedAt: Optional[TStamp]
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getDomainName: ZIO[Any, AwsError, DomainNameString] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getSubjectAlternativeNameSummaries
        : ZIO[Any, AwsError, List[DomainNameString]] =
      AwsError.unwrapOptionField(
        "subjectAlternativeNameSummaries",
        subjectAlternativeNameSummaries
      )
    def getHasAdditionalSubjectAlternativeNames
        : ZIO[Any, AwsError, NullableBoolean] = AwsError.unwrapOptionField(
      "hasAdditionalSubjectAlternativeNames",
      hasAdditionalSubjectAlternativeNames
    )
    def getStatus: ZIO[Any, AwsError, zio.aws.acm.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
    def getType: ZIO[Any, AwsError, zio.aws.acm.model.CertificateType] =
      AwsError.unwrapOptionField("type", `type`)
    def getKeyAlgorithm: ZIO[Any, AwsError, zio.aws.acm.model.KeyAlgorithm] =
      AwsError.unwrapOptionField("keyAlgorithm", keyAlgorithm)
    def getKeyUsages: ZIO[Any, AwsError, List[zio.aws.acm.model.KeyUsageName]] =
      AwsError.unwrapOptionField("keyUsages", keyUsages)
    def getExtendedKeyUsages
        : ZIO[Any, AwsError, List[zio.aws.acm.model.ExtendedKeyUsageName]] =
      AwsError.unwrapOptionField("extendedKeyUsages", extendedKeyUsages)
    def getInUse: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("inUse", inUse)
    def getExported: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("exported", exported)
    def getRenewalEligibility
        : ZIO[Any, AwsError, zio.aws.acm.model.RenewalEligibility] =
      AwsError.unwrapOptionField("renewalEligibility", renewalEligibility)
    def getNotBefore: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notBefore", notBefore)
    def getNotAfter: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("notAfter", notAfter)
    def getCreatedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getIssuedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("issuedAt", issuedAt)
    def getImportedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("importedAt", importedAt)
    def getRevokedAt: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("revokedAt", revokedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.CertificateSummary
  ) extends zio.aws.acm.model.CertificateSummary.ReadOnly {
    override val certificateArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
    override val domainName: Optional[DomainNameString] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.acm.model.primitives.DomainNameString(value))
    override val subjectAlternativeNameSummaries
        : Optional[List[DomainNameString]] = zio.aws.core.internal
      .optionalFromNullable(impl.subjectAlternativeNameSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.primitives.DomainNameString(item)
        }.toList
      )
    override val hasAdditionalSubjectAlternativeNames
        : Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.hasAdditionalSubjectAlternativeNames())
      .map(value => value: NullableBoolean)
    override val status: Optional[zio.aws.acm.model.CertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.acm.model.CertificateStatus.wrap(value))
    override val `type`: Optional[zio.aws.acm.model.CertificateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.acm.model.CertificateType.wrap(value))
    override val keyAlgorithm: Optional[zio.aws.acm.model.KeyAlgorithm] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyAlgorithm())
        .map(value => zio.aws.acm.model.KeyAlgorithm.wrap(value))
    override val keyUsages: Optional[List[zio.aws.acm.model.KeyUsageName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyUsages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.KeyUsageName.wrap(item)
          }.toList
        )
    override val extendedKeyUsages
        : Optional[List[zio.aws.acm.model.ExtendedKeyUsageName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extendedKeyUsages())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.ExtendedKeyUsageName.wrap(item)
          }.toList
        )
    override val inUse: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.inUse())
      .map(value => value: NullableBoolean)
    override val exported: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.exported())
      .map(value => value: NullableBoolean)
    override val renewalEligibility
        : Optional[zio.aws.acm.model.RenewalEligibility] = zio.aws.core.internal
      .optionalFromNullable(impl.renewalEligibility())
      .map(value => zio.aws.acm.model.RenewalEligibility.wrap(value))
    override val notBefore: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.notBefore())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val notAfter: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.notAfter())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val createdAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val issuedAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.issuedAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val importedAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.importedAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
    override val revokedAt: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.revokedAt())
      .map(value => zio.aws.acm.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.CertificateSummary
  ): zio.aws.acm.model.CertificateSummary.ReadOnly = new Wrapper(impl)
}
