package zio.aws.acm.model
import scala.jdk.CollectionConverters._
sealed trait RecordType {
  def unwrap: software.amazon.awssdk.services.acm.model.RecordType
}
object RecordType {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.RecordType
  ): zio.aws.acm.model.RecordType = value match {
    case software.amazon.awssdk.services.acm.model.RecordType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.RecordType.CNAME =>
      val r = CNAME
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.RecordType {
    override def unwrap: software.amazon.awssdk.services.acm.model.RecordType =
      software.amazon.awssdk.services.acm.model.RecordType.UNKNOWN_TO_SDK_VERSION
  }
  case object CNAME extends zio.aws.acm.model.RecordType {
    override def unwrap: software.amazon.awssdk.services.acm.model.RecordType =
      software.amazon.awssdk.services.acm.model.RecordType.CNAME
  }
}
