package zio.aws.acm.model
import zio.prelude.data.Optional
import zio.aws.acm.model.primitives.{MaxItems, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListCertificatesRequest(
    certificateStatuses: Optional[
      Iterable[zio.aws.acm.model.CertificateStatus]
    ] = Optional.Absent,
    includes: Optional[zio.aws.acm.model.Filters] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxItems: Optional[MaxItems] = Optional.Absent,
    sortBy: Optional[zio.aws.acm.model.SortBy] = Optional.Absent,
    sortOrder: Optional[zio.aws.acm.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ListCertificatesRequest = {
    import ListCertificatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ListCertificatesRequest
      .builder()
      .optionallyWith(
        certificateStatuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.certificateStatusesWithStrings)
      .optionallyWith(includes.map(value => value.buildAwsValue()))(_.includes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ListCertificatesRequest.ReadOnly =
    zio.aws.acm.model.ListCertificatesRequest.wrap(buildAwsValue())
}
object ListCertificatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ListCertificatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ListCertificatesRequest =
      zio.aws.acm.model.ListCertificatesRequest(
        certificateStatuses.map(value => value),
        includes.map(value => value.asEditable),
        nextToken.map(value => value),
        maxItems.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def certificateStatuses: Optional[List[zio.aws.acm.model.CertificateStatus]]
    def includes: Optional[zio.aws.acm.model.Filters.ReadOnly]
    def nextToken: Optional[NextToken]
    def maxItems: Optional[MaxItems]
    def sortBy: Optional[zio.aws.acm.model.SortBy]
    def sortOrder: Optional[zio.aws.acm.model.SortOrder]
    def getCertificateStatuses
        : ZIO[Any, AwsError, List[zio.aws.acm.model.CertificateStatus]] =
      AwsError.unwrapOptionField("certificateStatuses", certificateStatuses)
    def getIncludes: ZIO[Any, AwsError, zio.aws.acm.model.Filters.ReadOnly] =
      AwsError.unwrapOptionField("includes", includes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getSortBy: ZIO[Any, AwsError, zio.aws.acm.model.SortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.acm.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ListCertificatesRequest
  ) extends zio.aws.acm.model.ListCertificatesRequest.ReadOnly {
    override val certificateStatuses
        : Optional[List[zio.aws.acm.model.CertificateStatus]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateStatuses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.acm.model.CertificateStatus.wrap(item)
          }.toList
        )
    override val includes: Optional[zio.aws.acm.model.Filters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value => zio.aws.acm.model.Filters.wrap(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.acm.model.primitives.NextToken(value))
    override val maxItems: Optional[MaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.acm.model.primitives.MaxItems(value))
    override val sortBy: Optional[zio.aws.acm.model.SortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.acm.model.SortBy.wrap(value))
    override val sortOrder: Optional[zio.aws.acm.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.acm.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ListCertificatesRequest
  ): zio.aws.acm.model.ListCertificatesRequest.ReadOnly = new Wrapper(impl)
}
