package zio.aws.acm.model
import scala.jdk.CollectionConverters._
sealed trait FailureReason {
  def unwrap: software.amazon.awssdk.services.acm.model.FailureReason
}
object FailureReason {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.FailureReason
  ): zio.aws.acm.model.FailureReason = value match {
    case software.amazon.awssdk.services.acm.model.FailureReason.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.NO_AVAILABLE_CONTACTS =>
      val r = NO_AVAILABLE_CONTACTS
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.ADDITIONAL_VERIFICATION_REQUIRED =>
      val r = ADDITIONAL_VERIFICATION_REQUIRED
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.DOMAIN_NOT_ALLOWED =>
      val r = DOMAIN_NOT_ALLOWED
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.INVALID_PUBLIC_DOMAIN =>
      val r = INVALID_PUBLIC_DOMAIN
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.DOMAIN_VALIDATION_DENIED =>
      val r = DOMAIN_VALIDATION_DENIED
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.CAA_ERROR =>
      val r = CAA_ERROR
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.PCA_LIMIT_EXCEEDED =>
      val r = PCA_LIMIT_EXCEEDED
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.PCA_INVALID_ARN =>
      val r = PCA_INVALID_ARN
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.PCA_INVALID_STATE =>
      val r = PCA_INVALID_STATE
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.PCA_REQUEST_FAILED =>
      val r = PCA_REQUEST_FAILED
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.PCA_NAME_CONSTRAINTS_VALIDATION =>
      val r = PCA_NAME_CONSTRAINTS_VALIDATION
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.PCA_RESOURCE_NOT_FOUND =>
      val r = PCA_RESOURCE_NOT_FOUND
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.PCA_INVALID_ARGS =>
      val r = PCA_INVALID_ARGS
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.PCA_INVALID_DURATION =>
      val r = PCA_INVALID_DURATION
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.PCA_ACCESS_DENIED =>
      val r = PCA_ACCESS_DENIED
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.SLR_NOT_FOUND =>
      val r = SLR_NOT_FOUND
      r
    case software.amazon.awssdk.services.acm.model.FailureReason.OTHER =>
      val r = OTHER
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.UNKNOWN_TO_SDK_VERSION
  }
  case object NO_AVAILABLE_CONTACTS extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.NO_AVAILABLE_CONTACTS
  }
  case object ADDITIONAL_VERIFICATION_REQUIRED
      extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.ADDITIONAL_VERIFICATION_REQUIRED
  }
  case object DOMAIN_NOT_ALLOWED extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.DOMAIN_NOT_ALLOWED
  }
  case object INVALID_PUBLIC_DOMAIN extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.INVALID_PUBLIC_DOMAIN
  }
  case object DOMAIN_VALIDATION_DENIED extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.DOMAIN_VALIDATION_DENIED
  }
  case object CAA_ERROR extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.CAA_ERROR
  }
  case object PCA_LIMIT_EXCEEDED extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.PCA_LIMIT_EXCEEDED
  }
  case object PCA_INVALID_ARN extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.PCA_INVALID_ARN
  }
  case object PCA_INVALID_STATE extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.PCA_INVALID_STATE
  }
  case object PCA_REQUEST_FAILED extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.PCA_REQUEST_FAILED
  }
  case object PCA_NAME_CONSTRAINTS_VALIDATION
      extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.PCA_NAME_CONSTRAINTS_VALIDATION
  }
  case object PCA_RESOURCE_NOT_FOUND extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.PCA_RESOURCE_NOT_FOUND
  }
  case object PCA_INVALID_ARGS extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.PCA_INVALID_ARGS
  }
  case object PCA_INVALID_DURATION extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.PCA_INVALID_DURATION
  }
  case object PCA_ACCESS_DENIED extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.PCA_ACCESS_DENIED
  }
  case object SLR_NOT_FOUND extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.SLR_NOT_FOUND
  }
  case object OTHER extends zio.aws.acm.model.FailureReason {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.FailureReason =
      software.amazon.awssdk.services.acm.model.FailureReason.OTHER
  }
}
