package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class DescribeCertificateRequest(certificateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.DescribeCertificateRequest = {
    import DescribeCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.DescribeCertificateRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.DescribeCertificateRequest.ReadOnly =
    zio.aws.acm.model.DescribeCertificateRequest.wrap(buildAwsValue())
}
object DescribeCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.DescribeCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.DescribeCertificateRequest =
      zio.aws.acm.model.DescribeCertificateRequest(certificateArn)
    def certificateArn: Arn
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.DescribeCertificateRequest
  ) extends zio.aws.acm.model.DescribeCertificateRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.DescribeCertificateRequest
  ): zio.aws.acm.model.DescribeCertificateRequest.ReadOnly = new Wrapper(impl)
}
