package zio.aws.acm
import zio.aws.acm.model.primitives.CertificateChain.Type
import java.time.Instant
import zio.aws.acm.model.primitives.DomainNameString
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.acm.model.primitives.Arn.Type
    object CertificateBody extends Subtype[String]
    type CertificateBody = zio.aws.acm.model.primitives.CertificateBody.Type
    object CertificateBodyBlob extends Subtype[Chunk[Byte]]
    type CertificateBodyBlob =
      zio.aws.acm.model.primitives.CertificateBodyBlob.Type
    object CertificateChain extends Subtype[String]
    type CertificateChain = zio.aws.acm.model.primitives.CertificateChain.Type
    object CertificateChainBlob extends Subtype[Chunk[Byte]]
    type CertificateChainBlob =
      zio.aws.acm.model.primitives.CertificateChainBlob.Type
    object DomainNameString extends Subtype[String]
    type DomainNameString = zio.aws.acm.model.primitives.DomainNameString.Type
    object IdempotencyToken extends Subtype[String]
    type IdempotencyToken = zio.aws.acm.model.primitives.IdempotencyToken.Type
    object MaxItems extends Subtype[Int]
    type MaxItems = zio.aws.acm.model.primitives.MaxItems.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.acm.model.primitives.NextToken.Type
    object PassphraseBlob extends Subtype[Chunk[Byte]]
    type PassphraseBlob = zio.aws.acm.model.primitives.PassphraseBlob.Type
    object PositiveInteger extends Subtype[Int]
    type PositiveInteger = zio.aws.acm.model.primitives.PositiveInteger.Type
    object PrivateKey extends Subtype[String]
    type PrivateKey = zio.aws.acm.model.primitives.PrivateKey.Type
    object PrivateKeyBlob extends Subtype[Chunk[Byte]]
    type PrivateKeyBlob = zio.aws.acm.model.primitives.PrivateKeyBlob.Type
    object TStamp extends Subtype[Instant]
    type TStamp = zio.aws.acm.model.primitives.TStamp.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.acm.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.acm.model.primitives.TagValue.Type
  }
  type CertificateStatuses = List[zio.aws.acm.model.CertificateStatus]
  type CertificateSummaryList = List[zio.aws.acm.model.CertificateSummary]
  type DomainList = List[DomainNameString]
  type DomainValidationList = List[zio.aws.acm.model.DomainValidation]
  type DomainValidationOptionList =
    List[zio.aws.acm.model.DomainValidationOption]
  type ExtendedKeyUsageFilterList = List[zio.aws.acm.model.ExtendedKeyUsageName]
  type ExtendedKeyUsageList = List[zio.aws.acm.model.ExtendedKeyUsage]
  type InUseList = List[String]
  type KeyAlgorithmList = List[zio.aws.acm.model.KeyAlgorithm]
  type KeyUsageFilterList = List[zio.aws.acm.model.KeyUsageName]
  type KeyUsageList = List[zio.aws.acm.model.KeyUsage]
  type TagList = List[zio.aws.acm.model.Tag]
  type ValidationEmailList = List[String]
}
