package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListCertificatesResponse(
    nextToken: Option[NextToken] = None,
    certificateSummaryList: Option[
      Iterable[zio.aws.acm.model.CertificateSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ListCertificatesResponse = {
    import ListCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ListCertificatesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        certificateSummaryList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.certificateSummaryList)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ListCertificatesResponse.ReadOnly =
    zio.aws.acm.model.ListCertificatesResponse.wrap(buildAwsValue())
}
object ListCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ListCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ListCertificatesResponse =
      zio.aws.acm.model.ListCertificatesResponse(
        nextToken.map(value => value),
        certificateSummaryList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Option[NextToken]
    def certificateSummaryList
        : Option[List[zio.aws.acm.model.CertificateSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCertificateSummaryList: ZIO[Any, AwsError, List[
      zio.aws.acm.model.CertificateSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "certificateSummaryList",
      certificateSummaryList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ListCertificatesResponse
  ) extends zio.aws.acm.model.ListCertificatesResponse.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.acm.model.primitives.NextToken(value))
    override val certificateSummaryList
        : Option[List[zio.aws.acm.model.CertificateSummary.ReadOnly]] = scala
      .Option(impl.certificateSummaryList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.CertificateSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ListCertificatesResponse
  ): zio.aws.acm.model.ListCertificatesResponse.ReadOnly = new Wrapper(impl)
}
