package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class ListTagsForCertificateRequest(certificateArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ListTagsForCertificateRequest = {
    import ListTagsForCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ListTagsForCertificateRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ListTagsForCertificateRequest.ReadOnly =
    zio.aws.acm.model.ListTagsForCertificateRequest.wrap(buildAwsValue())
}
object ListTagsForCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ListTagsForCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ListTagsForCertificateRequest =
      zio.aws.acm.model.ListTagsForCertificateRequest(certificateArn)
    def certificateArn: Arn
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ListTagsForCertificateRequest
  ) extends zio.aws.acm.model.ListTagsForCertificateRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ListTagsForCertificateRequest
  ): zio.aws.acm.model.ListTagsForCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
