package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.TStamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class RenewalSummary(
    renewalStatus: zio.aws.acm.model.RenewalStatus,
    domainValidationOptions: Iterable[zio.aws.acm.model.DomainValidation],
    renewalStatusReason: Option[zio.aws.acm.model.FailureReason] = None,
    updatedAt: TStamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.RenewalSummary = {
    import RenewalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.RenewalSummary
      .builder()
      .renewalStatus(renewalStatus.unwrap)
      .domainValidationOptions(domainValidationOptions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(renewalStatusReason.map(value => value.unwrap))(
        _.renewalStatusReason
      )
      .updatedAt(TStamp.unwrap(updatedAt): Instant)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.RenewalSummary.ReadOnly =
    zio.aws.acm.model.RenewalSummary.wrap(buildAwsValue())
}
object RenewalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.RenewalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.RenewalSummary =
      zio.aws.acm.model.RenewalSummary(
        renewalStatus,
        domainValidationOptions.map { item =>
          item.asEditable
        },
        renewalStatusReason.map(value => value),
        updatedAt
      )
    def renewalStatus: zio.aws.acm.model.RenewalStatus
    def domainValidationOptions
        : List[zio.aws.acm.model.DomainValidation.ReadOnly]
    def renewalStatusReason: Option[zio.aws.acm.model.FailureReason]
    def updatedAt: TStamp
    def getRenewalStatus: ZIO[Any, Nothing, zio.aws.acm.model.RenewalStatus] =
      ZIO.succeed(renewalStatus)
    def getDomainValidationOptions
        : ZIO[Any, Nothing, List[zio.aws.acm.model.DomainValidation.ReadOnly]] =
      ZIO.succeed(domainValidationOptions)
    def getRenewalStatusReason
        : ZIO[Any, AwsError, zio.aws.acm.model.FailureReason] =
      AwsError.unwrapOptionField("renewalStatusReason", renewalStatusReason)
    def getUpdatedAt: ZIO[Any, Nothing, TStamp] = ZIO.succeed(updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.RenewalSummary
  ) extends zio.aws.acm.model.RenewalSummary.ReadOnly {
    override val renewalStatus: zio.aws.acm.model.RenewalStatus =
      zio.aws.acm.model.RenewalStatus.wrap(impl.renewalStatus())
    override val domainValidationOptions
        : List[zio.aws.acm.model.DomainValidation.ReadOnly] = impl
      .domainValidationOptions()
      .asScala
      .map { item =>
        zio.aws.acm.model.DomainValidation.wrap(item)
      }
      .toList
    override val renewalStatusReason: Option[zio.aws.acm.model.FailureReason] =
      scala
        .Option(impl.renewalStatusReason())
        .map(value => zio.aws.acm.model.FailureReason.wrap(value))
    override val updatedAt: TStamp =
      zio.aws.acm.model.primitives.TStamp(impl.updatedAt())
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.RenewalSummary
  ): zio.aws.acm.model.RenewalSummary.ReadOnly = new Wrapper(impl)
}
