package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{DomainNameString, Arn}
import scala.jdk.CollectionConverters._
final case class CertificateSummary(
    certificateArn: Option[Arn] = None,
    domainName: Option[DomainNameString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.CertificateSummary = {
    import CertificateSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.CertificateSummary
      .builder()
      .optionallyWith(
        certificateArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.certificateArn)
      .optionallyWith(
        domainName.map(value =>
          DomainNameString.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.CertificateSummary.ReadOnly =
    zio.aws.acm.model.CertificateSummary.wrap(buildAwsValue())
}
object CertificateSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.CertificateSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.CertificateSummary =
      zio.aws.acm.model.CertificateSummary(
        certificateArn.map(value => value),
        domainName.map(value => value)
      )
    def certificateArn: Option[Arn]
    def domainName: Option[DomainNameString]
    def getCertificateArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getDomainName: ZIO[Any, AwsError, DomainNameString] =
      AwsError.unwrapOptionField("domainName", domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.CertificateSummary
  ) extends zio.aws.acm.model.CertificateSummary.ReadOnly {
    override val certificateArn: Option[Arn] = scala
      .Option(impl.certificateArn())
      .map(value => zio.aws.acm.model.primitives.Arn(value))
    override val domainName: Option[DomainNameString] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.acm.model.primitives.DomainNameString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.CertificateSummary
  ): zio.aws.acm.model.CertificateSummary.ReadOnly = new Wrapper(impl)
}
