package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Filters(
    extendedKeyUsage: Option[Iterable[zio.aws.acm.model.ExtendedKeyUsageName]] =
      None,
    keyUsage: Option[Iterable[zio.aws.acm.model.KeyUsageName]] = None,
    keyTypes: Option[Iterable[zio.aws.acm.model.KeyAlgorithm]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.acm.model.Filters = {
    import Filters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.Filters
      .builder()
      .optionallyWith(
        extendedKeyUsage.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.extendedKeyUsageWithStrings)
      .optionallyWith(
        keyUsage.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.keyUsageWithStrings)
      .optionallyWith(
        keyTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.keyTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.Filters.ReadOnly =
    zio.aws.acm.model.Filters.wrap(buildAwsValue())
}
object Filters {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acm.model.Filters] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.Filters = zio.aws.acm.model.Filters(
      extendedKeyUsage.map(value => value),
      keyUsage.map(value => value),
      keyTypes.map(value => value)
    )
    def extendedKeyUsage: Option[List[zio.aws.acm.model.ExtendedKeyUsageName]]
    def keyUsage: Option[List[zio.aws.acm.model.KeyUsageName]]
    def keyTypes: Option[List[zio.aws.acm.model.KeyAlgorithm]]
    def getExtendedKeyUsage
        : ZIO[Any, AwsError, List[zio.aws.acm.model.ExtendedKeyUsageName]] =
      AwsError.unwrapOptionField("extendedKeyUsage", extendedKeyUsage)
    def getKeyUsage: ZIO[Any, AwsError, List[zio.aws.acm.model.KeyUsageName]] =
      AwsError.unwrapOptionField("keyUsage", keyUsage)
    def getKeyTypes: ZIO[Any, AwsError, List[zio.aws.acm.model.KeyAlgorithm]] =
      AwsError.unwrapOptionField("keyTypes", keyTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.Filters
  ) extends zio.aws.acm.model.Filters.ReadOnly {
    override val extendedKeyUsage
        : Option[List[zio.aws.acm.model.ExtendedKeyUsageName]] = scala
      .Option(impl.extendedKeyUsage())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.ExtendedKeyUsageName.wrap(item)
        }.toList
      )
    override val keyUsage: Option[List[zio.aws.acm.model.KeyUsageName]] = scala
      .Option(impl.keyUsage())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.KeyUsageName.wrap(item)
        }.toList
      )
    override val keyTypes: Option[List[zio.aws.acm.model.KeyAlgorithm]] = scala
      .Option(impl.keyTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.acm.model.KeyAlgorithm.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.Filters
  ): zio.aws.acm.model.Filters.ReadOnly = new Wrapper(impl)
}
