package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.acm.model.primitives.Arn
import scala.jdk.CollectionConverters._
final case class RemoveTagsFromCertificateRequest(
    certificateArn: Arn,
    tags: Iterable[zio.aws.acm.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.RemoveTagsFromCertificateRequest = {
    import RemoveTagsFromCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.RemoveTagsFromCertificateRequest
      .builder()
      .certificateArn(Arn.unwrap(certificateArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.RemoveTagsFromCertificateRequest.ReadOnly =
    zio.aws.acm.model.RemoveTagsFromCertificateRequest.wrap(buildAwsValue())
}
object RemoveTagsFromCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.RemoveTagsFromCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.RemoveTagsFromCertificateRequest =
      zio.aws.acm.model.RemoveTagsFromCertificateRequest(
        certificateArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def certificateArn: Arn
    def tags: List[zio.aws.acm.model.Tag.ReadOnly]
    def getCertificateArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(certificateArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.acm.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.RemoveTagsFromCertificateRequest
  ) extends zio.aws.acm.model.RemoveTagsFromCertificateRequest.ReadOnly {
    override val certificateArn: Arn =
      zio.aws.acm.model.primitives.Arn(impl.certificateArn())
    override val tags: List[zio.aws.acm.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.acm.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.RemoveTagsFromCertificateRequest
  ): zio.aws.acm.model.RemoveTagsFromCertificateRequest.ReadOnly = new Wrapper(
    impl
  )
}
