package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KeyUsage(name: Option[zio.aws.acm.model.KeyUsageName] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.acm.model.KeyUsage = {
    import KeyUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.KeyUsage
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.KeyUsage.ReadOnly =
    zio.aws.acm.model.KeyUsage.wrap(buildAwsValue())
}
object KeyUsage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.acm.model.KeyUsage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.KeyUsage =
      zio.aws.acm.model.KeyUsage(name.map(value => value))
    def name: Option[zio.aws.acm.model.KeyUsageName]
    def getName: ZIO[Any, AwsError, zio.aws.acm.model.KeyUsageName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.KeyUsage
  ) extends zio.aws.acm.model.KeyUsage.ReadOnly {
    override val name: Option[zio.aws.acm.model.KeyUsageName] = scala
      .Option(impl.name())
      .map(value => zio.aws.acm.model.KeyUsageName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.KeyUsage
  ): zio.aws.acm.model.KeyUsage.ReadOnly = new Wrapper(impl)
}
