package zio.aws.acm.model
import scala.jdk.CollectionConverters._
sealed trait KeyUsageName {
  def unwrap: software.amazon.awssdk.services.acm.model.KeyUsageName
}
object KeyUsageName {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.KeyUsageName
  ): zio.aws.acm.model.KeyUsageName = value match {
    case software.amazon.awssdk.services.acm.model.KeyUsageName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.DIGITAL_SIGNATURE =>
      val r = DIGITAL_SIGNATURE
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.NON_REPUDIATION =>
      val r = NON_REPUDIATION
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.KEY_ENCIPHERMENT =>
      val r = KEY_ENCIPHERMENT
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.DATA_ENCIPHERMENT =>
      val r = DATA_ENCIPHERMENT
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.KEY_AGREEMENT =>
      val r = KEY_AGREEMENT
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.CERTIFICATE_SIGNING =>
      val r = CERTIFICATE_SIGNING
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.CRL_SIGNING =>
      val r = CRL_SIGNING
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.ENCIPHER_ONLY =>
      val r = ENCIPHER_ONLY
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.DECIPHER_ONLY =>
      val r = DECIPHER_ONLY
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.ANY =>
      val r = ANY
      r
    case software.amazon.awssdk.services.acm.model.KeyUsageName.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.UNKNOWN_TO_SDK_VERSION
  }
  case object DIGITAL_SIGNATURE extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.DIGITAL_SIGNATURE
  }
  case object NON_REPUDIATION extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.NON_REPUDIATION
  }
  case object KEY_ENCIPHERMENT extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.KEY_ENCIPHERMENT
  }
  case object DATA_ENCIPHERMENT extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.DATA_ENCIPHERMENT
  }
  case object KEY_AGREEMENT extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.KEY_AGREEMENT
  }
  case object CERTIFICATE_SIGNING extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.CERTIFICATE_SIGNING
  }
  case object CRL_SIGNING extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.CRL_SIGNING
  }
  case object ENCIPHER_ONLY extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.ENCIPHER_ONLY
  }
  case object DECIPHER_ONLY extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.DECIPHER_ONLY
  }
  case object ANY extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.ANY
  }
  case object CUSTOM extends zio.aws.acm.model.KeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.KeyUsageName =
      software.amazon.awssdk.services.acm.model.KeyUsageName.CUSTOM
  }
}
