package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.acm.model.primitives.{CertificateChain, CertificateBody}
import scala.jdk.CollectionConverters._
final case class GetCertificateResponse(
    certificate: Option[CertificateBody] = None,
    certificateChain: Option[CertificateChain] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.GetCertificateResponse = {
    import GetCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.GetCertificateResponse
      .builder()
      .optionallyWith(
        certificate.map(value =>
          CertificateBody.unwrap(value): java.lang.String
        )
      )(_.certificate)
      .optionallyWith(
        certificateChain.map(value =>
          CertificateChain.unwrap(value): java.lang.String
        )
      )(_.certificateChain)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.GetCertificateResponse.ReadOnly =
    zio.aws.acm.model.GetCertificateResponse.wrap(buildAwsValue())
}
object GetCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.GetCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.GetCertificateResponse =
      zio.aws.acm.model.GetCertificateResponse(
        certificate.map(value => value),
        certificateChain.map(value => value)
      )
    def certificate: Option[CertificateBody]
    def certificateChain: Option[CertificateChain]
    def getCertificate: ZIO[Any, AwsError, CertificateBody] =
      AwsError.unwrapOptionField("certificate", certificate)
    def getCertificateChain: ZIO[Any, AwsError, CertificateChain] =
      AwsError.unwrapOptionField("certificateChain", certificateChain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.GetCertificateResponse
  ) extends zio.aws.acm.model.GetCertificateResponse.ReadOnly {
    override val certificate: Option[CertificateBody] = scala
      .Option(impl.certificate())
      .map(value => zio.aws.acm.model.primitives.CertificateBody(value))
    override val certificateChain: Option[CertificateChain] = scala
      .Option(impl.certificateChain())
      .map(value => zio.aws.acm.model.primitives.CertificateChain(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.GetCertificateResponse
  ): zio.aws.acm.model.GetCertificateResponse.ReadOnly = new Wrapper(impl)
}
