package zio.aws.acm.model
import scala.jdk.CollectionConverters._
sealed trait RenewalEligibility {
  def unwrap: software.amazon.awssdk.services.acm.model.RenewalEligibility
}
object RenewalEligibility {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.RenewalEligibility
  ): zio.aws.acm.model.RenewalEligibility = value match {
    case software.amazon.awssdk.services.acm.model.RenewalEligibility.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.RenewalEligibility.ELIGIBLE =>
      val r = ELIGIBLE
      r
    case software.amazon.awssdk.services.acm.model.RenewalEligibility.INELIGIBLE =>
      val r = INELIGIBLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.RenewalEligibility {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RenewalEligibility =
      software.amazon.awssdk.services.acm.model.RenewalEligibility.UNKNOWN_TO_SDK_VERSION
  }
  case object ELIGIBLE extends zio.aws.acm.model.RenewalEligibility {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RenewalEligibility =
      software.amazon.awssdk.services.acm.model.RenewalEligibility.ELIGIBLE
  }
  case object INELIGIBLE extends zio.aws.acm.model.RenewalEligibility {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.RenewalEligibility =
      software.amazon.awssdk.services.acm.model.RenewalEligibility.INELIGIBLE
  }
}
