package zio.aws.acm.model
import scala.jdk.CollectionConverters._
sealed trait CertificateType {
  def unwrap: software.amazon.awssdk.services.acm.model.CertificateType
}
object CertificateType {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.CertificateType
  ): zio.aws.acm.model.CertificateType = value match {
    case software.amazon.awssdk.services.acm.model.CertificateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.CertificateType.IMPORTED =>
      val r = IMPORTED
      r
    case software.amazon.awssdk.services.acm.model.CertificateType.AMAZON_ISSUED =>
      val r = AMAZON_ISSUED
      r
    case software.amazon.awssdk.services.acm.model.CertificateType.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.CertificateType =
      software.amazon.awssdk.services.acm.model.CertificateType.UNKNOWN_TO_SDK_VERSION
  }
  case object IMPORTED extends zio.aws.acm.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.CertificateType =
      software.amazon.awssdk.services.acm.model.CertificateType.IMPORTED
  }
  case object AMAZON_ISSUED extends zio.aws.acm.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.CertificateType =
      software.amazon.awssdk.services.acm.model.CertificateType.AMAZON_ISSUED
  }
  case object PRIVATE extends zio.aws.acm.model.CertificateType {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.CertificateType =
      software.amazon.awssdk.services.acm.model.CertificateType.PRIVATE
  }
}
