package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCertificateResponse(
    certificate: Optional[zio.aws.acm.model.CertificateDetail] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.DescribeCertificateResponse = {
    import DescribeCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.DescribeCertificateResponse
      .builder()
      .optionallyWith(certificate.map(value => value.buildAwsValue()))(
        _.certificate
      )
      .build()
  }
  def asReadOnly: zio.aws.acm.model.DescribeCertificateResponse.ReadOnly =
    zio.aws.acm.model.DescribeCertificateResponse.wrap(buildAwsValue())
}
object DescribeCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.DescribeCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.DescribeCertificateResponse =
      zio.aws.acm.model
        .DescribeCertificateResponse(certificate.map(value => value.asEditable))
    def certificate: Optional[zio.aws.acm.model.CertificateDetail.ReadOnly]
    def getCertificate
        : ZIO[Any, AwsError, zio.aws.acm.model.CertificateDetail.ReadOnly] =
      AwsError.unwrapOptionField("certificate", certificate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.DescribeCertificateResponse
  ) extends zio.aws.acm.model.DescribeCertificateResponse.ReadOnly {
    override val certificate
        : Optional[zio.aws.acm.model.CertificateDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificate())
        .map(value => zio.aws.acm.model.CertificateDetail.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.DescribeCertificateResponse
  ): zio.aws.acm.model.DescribeCertificateResponse.ReadOnly = new Wrapper(impl)
}
