package zio.aws.acm
import zio.mock.{Proxy, Mock}
import zio.aws.acm.model.RequestCertificateResponse.ReadOnly
import zio.aws.core.AwsError
import software.amazon.awssdk.services.acm.AcmAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.acm.model.{
  ResendValidationEmailRequest,
  UpdateCertificateOptionsRequest,
  RenewCertificateRequest,
  RequestCertificateRequest,
  ExportCertificateRequest,
  RemoveTagsFromCertificateRequest,
  ListTagsForCertificateRequest,
  ListCertificatesRequest,
  ImportCertificateRequest,
  AddTagsToCertificateRequest,
  DescribeCertificateRequest,
  DeleteCertificateRequest,
  PutAccountConfigurationRequest,
  GetCertificateRequest
}
object AcmMock extends Mock[Acm] {
  object PutAccountConfiguration
      extends Effect[PutAccountConfigurationRequest, AwsError, Unit]
  object RequestCertificate
      extends Effect[RequestCertificateRequest, AwsError, ReadOnly]
  object ExportCertificate
      extends Effect[
        ExportCertificateRequest,
        AwsError,
        zio.aws.acm.model.ExportCertificateResponse.ReadOnly
      ]
  object AddTagsToCertificate
      extends Effect[AddTagsToCertificateRequest, AwsError, Unit]
  object ListTagsForCertificate
      extends Effect[
        ListTagsForCertificateRequest,
        AwsError,
        zio.aws.acm.model.ListTagsForCertificateResponse.ReadOnly
      ]
  object DeleteCertificate
      extends Effect[DeleteCertificateRequest, AwsError, Unit]
  object UpdateCertificateOptions
      extends Effect[UpdateCertificateOptionsRequest, AwsError, Unit]
  object ResendValidationEmail
      extends Effect[ResendValidationEmailRequest, AwsError, Unit]
  object GetCertificate
      extends Effect[
        GetCertificateRequest,
        AwsError,
        zio.aws.acm.model.GetCertificateResponse.ReadOnly
      ]
  object DescribeCertificate
      extends Effect[
        DescribeCertificateRequest,
        AwsError,
        zio.aws.acm.model.DescribeCertificateResponse.ReadOnly
      ]
  object RemoveTagsFromCertificate
      extends Effect[RemoveTagsFromCertificateRequest, AwsError, Unit]
  object RenewCertificate
      extends Effect[RenewCertificateRequest, AwsError, Unit]
  object ListCertificates
      extends Stream[
        ListCertificatesRequest,
        AwsError,
        zio.aws.acm.model.CertificateSummary.ReadOnly
      ]
  object ListCertificatesPaginated
      extends Effect[
        ListCertificatesRequest,
        AwsError,
        zio.aws.acm.model.ListCertificatesResponse.ReadOnly
      ]
  object ImportCertificate
      extends Effect[
        ImportCertificateRequest,
        AwsError,
        zio.aws.acm.model.ImportCertificateResponse.ReadOnly
      ]
  object GetAccountConfiguration
      extends Effect[
        Unit,
        AwsError,
        zio.aws.acm.model.GetAccountConfigurationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Acm] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Acm] { rts =>
        zio.ZIO.succeed {
          new Acm {
            val api: AcmAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Acm = this
            def putAccountConfiguration(
                request: PutAccountConfigurationRequest
            ): IO[AwsError, Unit] = proxy(PutAccountConfiguration, request)
            def requestCertificate(
                request: RequestCertificateRequest
            ): IO[AwsError, ReadOnly] = proxy(RequestCertificate, request)
            def exportCertificate(request: ExportCertificateRequest): IO[
              AwsError,
              zio.aws.acm.model.ExportCertificateResponse.ReadOnly
            ] = proxy(ExportCertificate, request)
            def addTagsToCertificate(
                request: AddTagsToCertificateRequest
            ): IO[AwsError, Unit] = proxy(AddTagsToCertificate, request)
            def listTagsForCertificate(
                request: ListTagsForCertificateRequest
            ): IO[
              AwsError,
              zio.aws.acm.model.ListTagsForCertificateResponse.ReadOnly
            ] = proxy(ListTagsForCertificate, request)
            def deleteCertificate(
                request: DeleteCertificateRequest
            ): IO[AwsError, Unit] = proxy(DeleteCertificate, request)
            def updateCertificateOptions(
                request: UpdateCertificateOptionsRequest
            ): IO[AwsError, Unit] = proxy(UpdateCertificateOptions, request)
            def resendValidationEmail(
                request: ResendValidationEmailRequest
            ): IO[AwsError, Unit] = proxy(ResendValidationEmail, request)
            def getCertificate(
                request: GetCertificateRequest
            ): IO[AwsError, zio.aws.acm.model.GetCertificateResponse.ReadOnly] =
              proxy(GetCertificate, request)
            def describeCertificate(request: DescribeCertificateRequest): IO[
              AwsError,
              zio.aws.acm.model.DescribeCertificateResponse.ReadOnly
            ] = proxy(DescribeCertificate, request)
            def removeTagsFromCertificate(
                request: RemoveTagsFromCertificateRequest
            ): IO[AwsError, Unit] = proxy(RemoveTagsFromCertificate, request)
            def renewCertificate(
                request: RenewCertificateRequest
            ): IO[AwsError, Unit] = proxy(RenewCertificate, request)
            def listCertificates(request: ListCertificatesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.acm.model.CertificateSummary.ReadOnly
            ] = rts.unsafeRun(proxy(ListCertificates, request))
            def listCertificatesPaginated(request: ListCertificatesRequest): IO[
              AwsError,
              zio.aws.acm.model.ListCertificatesResponse.ReadOnly
            ] = proxy(ListCertificatesPaginated, request)
            def importCertificate(request: ImportCertificateRequest): IO[
              AwsError,
              zio.aws.acm.model.ImportCertificateResponse.ReadOnly
            ] = proxy(ImportCertificate, request)
            def getAccountConfiguration(): IO[
              AwsError,
              zio.aws.acm.model.GetAccountConfigurationResponse.ReadOnly
            ] = proxy(GetAccountConfiguration)
          }
        }
      }
    }
  }
}
