package zio.aws.acm.model
import scala.jdk.CollectionConverters._
sealed trait DomainStatus {
  def unwrap: software.amazon.awssdk.services.acm.model.DomainStatus
}
object DomainStatus {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.DomainStatus
  ): zio.aws.acm.model.DomainStatus = value match {
    case software.amazon.awssdk.services.acm.model.DomainStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.DomainStatus.PENDING_VALIDATION =>
      val r = PENDING_VALIDATION
      r
    case software.amazon.awssdk.services.acm.model.DomainStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.acm.model.DomainStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.acm.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.DomainStatus =
      software.amazon.awssdk.services.acm.model.DomainStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_VALIDATION extends zio.aws.acm.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.DomainStatus =
      software.amazon.awssdk.services.acm.model.DomainStatus.PENDING_VALIDATION
  }
  case object SUCCESS extends zio.aws.acm.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.DomainStatus =
      software.amazon.awssdk.services.acm.model.DomainStatus.SUCCESS
  }
  case object FAILED extends zio.aws.acm.model.DomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.DomainStatus =
      software.amazon.awssdk.services.acm.model.DomainStatus.FAILED
  }
}
