package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExtendedKeyUsage(
    name: Optional[zio.aws.acm.model.ExtendedKeyUsageName] = Optional.Absent,
    oid: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.ExtendedKeyUsage = {
    import ExtendedKeyUsage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.ExtendedKeyUsage
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(oid.map(value => value: java.lang.String))(_.oid)
      .build()
  }
  def asReadOnly: zio.aws.acm.model.ExtendedKeyUsage.ReadOnly =
    zio.aws.acm.model.ExtendedKeyUsage.wrap(buildAwsValue())
}
object ExtendedKeyUsage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.ExtendedKeyUsage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.ExtendedKeyUsage = zio.aws.acm.model
      .ExtendedKeyUsage(name.map(value => value), oid.map(value => value))
    def name: Optional[zio.aws.acm.model.ExtendedKeyUsageName]
    def oid: Optional[String]
    def getName: ZIO[Any, AwsError, zio.aws.acm.model.ExtendedKeyUsageName] =
      AwsError.unwrapOptionField("name", name)
    def getOid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("oid", oid)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.ExtendedKeyUsage
  ) extends zio.aws.acm.model.ExtendedKeyUsage.ReadOnly {
    override val name: Optional[zio.aws.acm.model.ExtendedKeyUsageName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.acm.model.ExtendedKeyUsageName.wrap(value))
    override val oid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.oid())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.ExtendedKeyUsage
  ): zio.aws.acm.model.ExtendedKeyUsage.ReadOnly = new Wrapper(impl)
}
