package zio.aws.acm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetAccountConfigurationResponse(
    expiryEvents: Option[zio.aws.acm.model.ExpiryEventsConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.acm.model.GetAccountConfigurationResponse = {
    import GetAccountConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.acm.model.GetAccountConfigurationResponse
      .builder()
      .optionallyWith(expiryEvents.map(value => value.buildAwsValue()))(
        _.expiryEvents
      )
      .build()
  }
  def asReadOnly: zio.aws.acm.model.GetAccountConfigurationResponse.ReadOnly =
    zio.aws.acm.model.GetAccountConfigurationResponse.wrap(buildAwsValue())
}
object GetAccountConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.acm.model.GetAccountConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.acm.model.GetAccountConfigurationResponse =
      zio.aws.acm.model.GetAccountConfigurationResponse(
        expiryEvents.map(value => value.asEditable)
      )
    def expiryEvents
        : Option[zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly]
    def getExpiryEvents: ZIO[
      Any,
      AwsError,
      zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("expiryEvents", expiryEvents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.acm.model.GetAccountConfigurationResponse
  ) extends zio.aws.acm.model.GetAccountConfigurationResponse.ReadOnly {
    override val expiryEvents
        : Option[zio.aws.acm.model.ExpiryEventsConfiguration.ReadOnly] = scala
      .Option(impl.expiryEvents())
      .map(value => zio.aws.acm.model.ExpiryEventsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.acm.model.GetAccountConfigurationResponse
  ): zio.aws.acm.model.GetAccountConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
