package zio.aws.acm.model
import scala.jdk.CollectionConverters._
sealed trait ExtendedKeyUsageName {
  def unwrap: software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName
}
object ExtendedKeyUsageName {
  def wrap(
      value: software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName
  ): zio.aws.acm.model.ExtendedKeyUsageName = value match {
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.TLS_WEB_SERVER_AUTHENTICATION =>
      val r = TLS_WEB_SERVER_AUTHENTICATION
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.TLS_WEB_CLIENT_AUTHENTICATION =>
      val r = TLS_WEB_CLIENT_AUTHENTICATION
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.CODE_SIGNING =>
      val r = CODE_SIGNING
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.EMAIL_PROTECTION =>
      val r = EMAIL_PROTECTION
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.TIME_STAMPING =>
      val r = TIME_STAMPING
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.OCSP_SIGNING =>
      val r = OCSP_SIGNING
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.IPSEC_END_SYSTEM =>
      val r = IPSEC_END_SYSTEM
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.IPSEC_TUNNEL =>
      val r = IPSEC_TUNNEL
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.IPSEC_USER =>
      val r = IPSEC_USER
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.ANY =>
      val r = ANY
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.CUSTOM =>
      val r = CUSTOM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.UNKNOWN_TO_SDK_VERSION
  }
  case object TLS_WEB_SERVER_AUTHENTICATION
      extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.TLS_WEB_SERVER_AUTHENTICATION
  }
  case object TLS_WEB_CLIENT_AUTHENTICATION
      extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.TLS_WEB_CLIENT_AUTHENTICATION
  }
  case object CODE_SIGNING extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.CODE_SIGNING
  }
  case object EMAIL_PROTECTION extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.EMAIL_PROTECTION
  }
  case object TIME_STAMPING extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.TIME_STAMPING
  }
  case object OCSP_SIGNING extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.OCSP_SIGNING
  }
  case object IPSEC_END_SYSTEM extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.IPSEC_END_SYSTEM
  }
  case object IPSEC_TUNNEL extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.IPSEC_TUNNEL
  }
  case object IPSEC_USER extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.IPSEC_USER
  }
  case object ANY extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.ANY
  }
  case object NONE extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.NONE
  }
  case object CUSTOM extends zio.aws.acm.model.ExtendedKeyUsageName {
    override def unwrap
        : software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName =
      software.amazon.awssdk.services.acm.model.ExtendedKeyUsageName.CUSTOM
  }
}
