package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ValidatePolicyResponse(
    findings: Iterable[zio.aws.accessanalyzer.model.ValidatePolicyFinding],
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse = {
    import ValidatePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse
      .builder()
      .findings(findings.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.ValidatePolicyResponse.ReadOnly =
    zio.aws.accessanalyzer.model.ValidatePolicyResponse.wrap(buildAwsValue())
}
object ValidatePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ValidatePolicyResponse =
      zio.aws.accessanalyzer.model.ValidatePolicyResponse(
        findings.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def findings
        : List[zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly]
    def nextToken: Optional[Token]
    def getFindings: ZIO[Any, Nothing, List[
      zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly
    ]] = ZIO.succeed(findings)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse
  ) extends zio.aws.accessanalyzer.model.ValidatePolicyResponse.ReadOnly {
    override val findings
        : List[zio.aws.accessanalyzer.model.ValidatePolicyFinding.ReadOnly] =
      impl
        .findings()
        .asScala
        .map { item =>
          zio.aws.accessanalyzer.model.ValidatePolicyFinding.wrap(item)
        }
        .toList
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyResponse
  ): zio.aws.accessanalyzer.model.ValidatePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
