package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Span(
    start: zio.aws.accessanalyzer.model.Position,
    end: zio.aws.accessanalyzer.model.Position
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Span = {
    import Span.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Span
      .builder()
      .start(start.buildAwsValue())
      .end(end.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Span.ReadOnly =
    zio.aws.accessanalyzer.model.Span.wrap(buildAwsValue())
}
object Span {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Span
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Span =
      zio.aws.accessanalyzer.model.Span(start.asEditable, end.asEditable)
    def start: zio.aws.accessanalyzer.model.Position.ReadOnly
    def end: zio.aws.accessanalyzer.model.Position.ReadOnly
    def getStart
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.Position.ReadOnly] =
      ZIO.succeed(start)
    def getEnd
        : ZIO[Any, Nothing, zio.aws.accessanalyzer.model.Position.ReadOnly] =
      ZIO.succeed(end)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Span
  ) extends zio.aws.accessanalyzer.model.Span.ReadOnly {
    override val start: zio.aws.accessanalyzer.model.Position.ReadOnly =
      zio.aws.accessanalyzer.model.Position.wrap(impl.start())
    override val end: zio.aws.accessanalyzer.model.Position.ReadOnly =
      zio.aws.accessanalyzer.model.Position.wrap(impl.end())
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Span
  ): zio.aws.accessanalyzer.model.Span.ReadOnly = new Wrapper(impl)
}
