package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.SnsTopicPolicy
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SnsTopicConfiguration(
    topicPolicy: Optional[SnsTopicPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.SnsTopicConfiguration = {
    import SnsTopicConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.SnsTopicConfiguration
      .builder()
      .optionallyWith(
        topicPolicy.map(value => SnsTopicPolicy.unwrap(value): java.lang.String)
      )(_.topicPolicy)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.SnsTopicConfiguration.ReadOnly =
    zio.aws.accessanalyzer.model.SnsTopicConfiguration.wrap(buildAwsValue())
}
object SnsTopicConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.SnsTopicConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.SnsTopicConfiguration =
      zio.aws.accessanalyzer.model
        .SnsTopicConfiguration(topicPolicy.map(value => value))
    def topicPolicy: Optional[SnsTopicPolicy]
    def getTopicPolicy: ZIO[Any, AwsError, SnsTopicPolicy] =
      AwsError.unwrapOptionField("topicPolicy", topicPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.SnsTopicConfiguration
  ) extends zio.aws.accessanalyzer.model.SnsTopicConfiguration.ReadOnly {
    override val topicPolicy: Optional[SnsTopicPolicy] = zio.aws.core.internal
      .optionalFromNullable(impl.topicPolicy())
      .map(value =>
        zio.aws.accessanalyzer.model.primitives.SnsTopicPolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.SnsTopicConfiguration
  ): zio.aws.accessanalyzer.model.SnsTopicConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
