package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{
  Integer,
  Token,
  AnalyzerArn,
  AccessPreviewId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAccessPreviewFindingsRequest(
    accessPreviewId: AccessPreviewId,
    analyzerArn: AnalyzerArn,
    filter: Optional[Map[String, zio.aws.accessanalyzer.model.Criterion]] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest = {
    import ListAccessPreviewFindingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
      .builder()
      .accessPreviewId(
        AccessPreviewId.unwrap(accessPreviewId): java.lang.String
      )
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.filter)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest
      .wrap(buildAwsValue())
}
object ListAccessPreviewFindingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest =
      zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest(
        accessPreviewId,
        analyzerArn,
        filter.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def accessPreviewId: AccessPreviewId
    def analyzerArn: AnalyzerArn
    def filter
        : Optional[Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]]
    def nextToken: Optional[Token]
    def maxResults: Optional[Integer]
    def getAccessPreviewId: ZIO[Any, Nothing, AccessPreviewId] =
      ZIO.succeed(accessPreviewId)
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getFilter: ZIO[Any, AwsError, Map[
      String,
      zio.aws.accessanalyzer.model.Criterion.ReadOnly
    ]] = AwsError.unwrapOptionField("filter", filter)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
  ) extends zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest.ReadOnly {
    override val accessPreviewId: AccessPreviewId =
      zio.aws.accessanalyzer.model.primitives
        .AccessPreviewId(impl.accessPreviewId())
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val filter: Optional[
      Map[String, zio.aws.accessanalyzer.model.Criterion.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> zio.aws.accessanalyzer.model.Criterion.wrap(value)
          })
          .toMap
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest
  ): zio.aws.accessanalyzer.model.ListAccessPreviewFindingsRequest.ReadOnly =
    new Wrapper(impl)
}
