package zio.aws.accessanalyzer.model
import scala.jdk.CollectionConverters.*
sealed trait FindingStatusUpdate {
  def unwrap
      : software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate
}
object FindingStatusUpdate {
  def wrap(
      value: software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate
  ): zio.aws.accessanalyzer.model.FindingStatusUpdate = value match {
    case software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate.ARCHIVED =>
      val r = ARCHIVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.accessanalyzer.model.FindingStatusUpdate {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate =
      software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.accessanalyzer.model.FindingStatusUpdate {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate =
      software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate.ACTIVE
  }
  case object ARCHIVED
      extends zio.aws.accessanalyzer.model.FindingStatusUpdate {
    override def unwrap
        : software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate =
      software.amazon.awssdk.services.accessanalyzer.model.FindingStatusUpdate.ARCHIVED
  }
}
