package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Substring(start: Integer, length: Integer) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Substring = {
    import Substring.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Substring
      .builder()
      .start(start: java.lang.Integer)
      .length(length: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Substring.ReadOnly =
    zio.aws.accessanalyzer.model.Substring.wrap(buildAwsValue())
}
object Substring {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Substring
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Substring =
      zio.aws.accessanalyzer.model.Substring(start, length)
    def start: Integer
    def length: Integer
    def getStart: ZIO[Any, Nothing, Integer] = ZIO.succeed(start)
    def getLength: ZIO[Any, Nothing, Integer] = ZIO.succeed(length)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Substring
  ) extends zio.aws.accessanalyzer.model.Substring.ReadOnly {
    override val start: Integer = impl.start(): Integer
    override val length: Integer = impl.length(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Substring
  ): zio.aws.accessanalyzer.model.Substring.ReadOnly = new Wrapper(impl)
}
