package zio.aws.accessanalyzer.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.accessanalyzer.model.primitives.{
  Token,
  ListPolicyGenerationsRequestMaxResultsInteger,
  PrincipalArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListPolicyGenerationsRequest(
    principalArn: Optional[PrincipalArn] = Optional.Absent,
    maxResults: Optional[ListPolicyGenerationsRequestMaxResultsInteger] =
      Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest = {
    import ListPolicyGenerationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest
      .builder()
      .optionallyWith(
        principalArn.map(value => PrincipalArn.unwrap(value): java.lang.String)
      )(_.principalArn)
      .optionallyWith(
        maxResults.map(value =>
          ListPolicyGenerationsRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest
      .wrap(buildAwsValue())
}
object ListPolicyGenerationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest =
      zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest(
        principalArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def principalArn: Optional[PrincipalArn]
    def maxResults: Optional[ListPolicyGenerationsRequestMaxResultsInteger]
    def nextToken: Optional[Token]
    def getPrincipalArn: ZIO[Any, AwsError, PrincipalArn] =
      AwsError.unwrapOptionField("principalArn", principalArn)
    def getMaxResults
        : ZIO[Any, AwsError, ListPolicyGenerationsRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest
  ) extends zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest.ReadOnly {
    override val principalArn: Optional[PrincipalArn] = zio.aws.core.internal
      .optionalFromNullable(impl.principalArn())
      .map(value => zio.aws.accessanalyzer.model.primitives.PrincipalArn(value))
    override val maxResults
        : Optional[ListPolicyGenerationsRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.accessanalyzer.model.primitives
            .ListPolicyGenerationsRequestMaxResultsInteger(value)
        )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest
  ): zio.aws.accessanalyzer.model.ListPolicyGenerationsRequest.ReadOnly =
    new Wrapper(impl)
}
