package zio.aws.accessanalyzer.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Configuration(
    ebsSnapshot: Optional[
      zio.aws.accessanalyzer.model.EbsSnapshotConfiguration
    ] = Optional.Absent,
    ecrRepository: Optional[
      zio.aws.accessanalyzer.model.EcrRepositoryConfiguration
    ] = Optional.Absent,
    iamRole: Optional[zio.aws.accessanalyzer.model.IamRoleConfiguration] =
      Optional.Absent,
    efsFileSystem: Optional[
      zio.aws.accessanalyzer.model.EfsFileSystemConfiguration
    ] = Optional.Absent,
    kmsKey: Optional[zio.aws.accessanalyzer.model.KmsKeyConfiguration] =
      Optional.Absent,
    rdsDbClusterSnapshot: Optional[
      zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration
    ] = Optional.Absent,
    rdsDbSnapshot: Optional[
      zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration
    ] = Optional.Absent,
    secretsManagerSecret: Optional[
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration
    ] = Optional.Absent,
    s3Bucket: Optional[zio.aws.accessanalyzer.model.S3BucketConfiguration] =
      Optional.Absent,
    snsTopic: Optional[zio.aws.accessanalyzer.model.SnsTopicConfiguration] =
      Optional.Absent,
    sqsQueue: Optional[zio.aws.accessanalyzer.model.SqsQueueConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.Configuration = {
    import Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.Configuration
      .builder()
      .optionallyWith(ebsSnapshot.map(value => value.buildAwsValue()))(
        _.ebsSnapshot
      )
      .optionallyWith(ecrRepository.map(value => value.buildAwsValue()))(
        _.ecrRepository
      )
      .optionallyWith(iamRole.map(value => value.buildAwsValue()))(_.iamRole)
      .optionallyWith(efsFileSystem.map(value => value.buildAwsValue()))(
        _.efsFileSystem
      )
      .optionallyWith(kmsKey.map(value => value.buildAwsValue()))(_.kmsKey)
      .optionallyWith(rdsDbClusterSnapshot.map(value => value.buildAwsValue()))(
        _.rdsDbClusterSnapshot
      )
      .optionallyWith(rdsDbSnapshot.map(value => value.buildAwsValue()))(
        _.rdsDbSnapshot
      )
      .optionallyWith(secretsManagerSecret.map(value => value.buildAwsValue()))(
        _.secretsManagerSecret
      )
      .optionallyWith(s3Bucket.map(value => value.buildAwsValue()))(_.s3Bucket)
      .optionallyWith(snsTopic.map(value => value.buildAwsValue()))(_.snsTopic)
      .optionallyWith(sqsQueue.map(value => value.buildAwsValue()))(_.sqsQueue)
      .build()
  }
  def asReadOnly: zio.aws.accessanalyzer.model.Configuration.ReadOnly =
    zio.aws.accessanalyzer.model.Configuration.wrap(buildAwsValue())
}
object Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.Configuration =
      zio.aws.accessanalyzer.model.Configuration(
        ebsSnapshot.map(value => value.asEditable),
        ecrRepository.map(value => value.asEditable),
        iamRole.map(value => value.asEditable),
        efsFileSystem.map(value => value.asEditable),
        kmsKey.map(value => value.asEditable),
        rdsDbClusterSnapshot.map(value => value.asEditable),
        rdsDbSnapshot.map(value => value.asEditable),
        secretsManagerSecret.map(value => value.asEditable),
        s3Bucket.map(value => value.asEditable),
        snsTopic.map(value => value.asEditable),
        sqsQueue.map(value => value.asEditable)
      )
    def ebsSnapshot: Optional[
      zio.aws.accessanalyzer.model.EbsSnapshotConfiguration.ReadOnly
    ]
    def ecrRepository: Optional[
      zio.aws.accessanalyzer.model.EcrRepositoryConfiguration.ReadOnly
    ]
    def iamRole
        : Optional[zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly]
    def efsFileSystem: Optional[
      zio.aws.accessanalyzer.model.EfsFileSystemConfiguration.ReadOnly
    ]
    def kmsKey
        : Optional[zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly]
    def rdsDbClusterSnapshot: Optional[
      zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration.ReadOnly
    ]
    def rdsDbSnapshot: Optional[
      zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration.ReadOnly
    ]
    def secretsManagerSecret: Optional[
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly
    ]
    def s3Bucket
        : Optional[zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly]
    def snsTopic
        : Optional[zio.aws.accessanalyzer.model.SnsTopicConfiguration.ReadOnly]
    def sqsQueue
        : Optional[zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly]
    def getEbsSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.EbsSnapshotConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ebsSnapshot", ebsSnapshot)
    def getEcrRepository: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.EcrRepositoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ecrRepository", ecrRepository)
    def getIamRole: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("iamRole", iamRole)
    def getEfsFileSystem: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.EfsFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("efsFileSystem", efsFileSystem)
    def getKmsKey: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getRdsDbClusterSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("rdsDbClusterSnapshot", rdsDbClusterSnapshot)
    def getRdsDbSnapshot: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("rdsDbSnapshot", rdsDbSnapshot)
    def getSecretsManagerSecret: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("secretsManagerSecret", secretsManagerSecret)
    def getS3Bucket: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Bucket", s3Bucket)
    def getSnsTopic: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.SnsTopicConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("snsTopic", snsTopic)
    def getSqsQueue: ZIO[
      Any,
      AwsError,
      zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sqsQueue", sqsQueue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Configuration
  ) extends zio.aws.accessanalyzer.model.Configuration.ReadOnly {
    override val ebsSnapshot: Optional[
      zio.aws.accessanalyzer.model.EbsSnapshotConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ebsSnapshot())
      .map(value =>
        zio.aws.accessanalyzer.model.EbsSnapshotConfiguration.wrap(value)
      )
    override val ecrRepository: Optional[
      zio.aws.accessanalyzer.model.EcrRepositoryConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ecrRepository())
      .map(value =>
        zio.aws.accessanalyzer.model.EcrRepositoryConfiguration.wrap(value)
      )
    override val iamRole
        : Optional[zio.aws.accessanalyzer.model.IamRoleConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamRole())
        .map(value =>
          zio.aws.accessanalyzer.model.IamRoleConfiguration.wrap(value)
        )
    override val efsFileSystem: Optional[
      zio.aws.accessanalyzer.model.EfsFileSystemConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.efsFileSystem())
      .map(value =>
        zio.aws.accessanalyzer.model.EfsFileSystemConfiguration.wrap(value)
      )
    override val kmsKey
        : Optional[zio.aws.accessanalyzer.model.KmsKeyConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKey())
        .map(value =>
          zio.aws.accessanalyzer.model.KmsKeyConfiguration.wrap(value)
        )
    override val rdsDbClusterSnapshot: Optional[
      zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rdsDbClusterSnapshot())
      .map(value =>
        zio.aws.accessanalyzer.model.RdsDbClusterSnapshotConfiguration
          .wrap(value)
      )
    override val rdsDbSnapshot: Optional[
      zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rdsDbSnapshot())
      .map(value =>
        zio.aws.accessanalyzer.model.RdsDbSnapshotConfiguration.wrap(value)
      )
    override val secretsManagerSecret: Optional[
      zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.secretsManagerSecret())
      .map(value =>
        zio.aws.accessanalyzer.model.SecretsManagerSecretConfiguration
          .wrap(value)
      )
    override val s3Bucket: Optional[
      zio.aws.accessanalyzer.model.S3BucketConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.s3Bucket())
      .map(value =>
        zio.aws.accessanalyzer.model.S3BucketConfiguration.wrap(value)
      )
    override val snsTopic: Optional[
      zio.aws.accessanalyzer.model.SnsTopicConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopic())
      .map(value =>
        zio.aws.accessanalyzer.model.SnsTopicConfiguration.wrap(value)
      )
    override val sqsQueue: Optional[
      zio.aws.accessanalyzer.model.SqsQueueConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sqsQueue())
      .map(value =>
        zio.aws.accessanalyzer.model.SqsQueueConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.Configuration
  ): zio.aws.accessanalyzer.model.Configuration.ReadOnly = new Wrapper(impl)
}
