package zio.aws.accessanalyzer.model
import zio.aws.accessanalyzer.model.primitives.{Integer, Token, AnalyzerArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAccessPreviewsRequest(
    analyzerArn: AnalyzerArn,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest = {
    import ListAccessPreviewsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest
      .builder()
      .analyzerArn(AnalyzerArn.unwrap(analyzerArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.accessanalyzer.model.ListAccessPreviewsRequest.ReadOnly =
    zio.aws.accessanalyzer.model.ListAccessPreviewsRequest.wrap(buildAwsValue())
}
object ListAccessPreviewsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.accessanalyzer.model.ListAccessPreviewsRequest =
      zio.aws.accessanalyzer.model.ListAccessPreviewsRequest(
        analyzerArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def analyzerArn: AnalyzerArn
    def nextToken: Optional[Token]
    def maxResults: Optional[Integer]
    def getAnalyzerArn: ZIO[Any, Nothing, AnalyzerArn] =
      ZIO.succeed(analyzerArn)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest
  ) extends zio.aws.accessanalyzer.model.ListAccessPreviewsRequest.ReadOnly {
    override val analyzerArn: AnalyzerArn =
      zio.aws.accessanalyzer.model.primitives.AnalyzerArn(impl.analyzerArn())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.accessanalyzer.model.primitives.Token(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewsRequest
  ): zio.aws.accessanalyzer.model.ListAccessPreviewsRequest.ReadOnly =
    new Wrapper(impl)
}
